/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xmljson;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSON;
import net.sf.json.JSONSerializer;
import net.sf.json.xml.XMLSerializer;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.xmljson.TypeHintsEnum;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;

public class XmlJsonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private XMLSerializer serializer;
    private String encoding;
    private String elementName;
    private String arrayName;
    private Boolean forceTopLevelObject;
    private Boolean namespaceLenient;
    private List<NamespacesPerElementMapping> namespaceMappings;
    private String rootName;
    private Boolean skipWhitespace;
    private Boolean trimSpaces;
    private Boolean skipNamespaces;
    private Boolean removeNamespacePrefixes;
    private List<String> expandableProperties;
    private TypeHintsEnum typeHints;

    public String getDataFormatName() {
        return "xmljson";
    }

    protected void doStart() throws Exception {
        this.serializer = new XMLSerializer();
        if (this.forceTopLevelObject != null) {
            this.serializer.setForceTopLevelObject(this.forceTopLevelObject.booleanValue());
        }
        if (this.namespaceLenient != null) {
            this.serializer.setNamespaceLenient(this.namespaceLenient.booleanValue());
        }
        if (this.namespaceMappings != null) {
            for (NamespacesPerElementMapping nsMapping : this.namespaceMappings) {
                for (Map.Entry<String, String> entry : nsMapping.namespaces.entrySet()) {
                    this.serializer.addNamespace(entry.getKey(), entry.getValue(), nsMapping.element);
                }
            }
        }
        if (this.rootName != null) {
            this.serializer.setRootName(this.rootName);
        }
        if (this.elementName != null) {
            this.serializer.setElementName(this.elementName);
        }
        if (this.arrayName != null) {
            this.serializer.setArrayName(this.arrayName);
        }
        if (this.expandableProperties != null && this.expandableProperties.size() != 0) {
            this.serializer.setExpandableProperties(this.expandableProperties.toArray(new String[this.expandableProperties.size()]));
        }
        if (this.skipWhitespace != null) {
            this.serializer.setSkipWhitespace(this.skipWhitespace.booleanValue());
        }
        if (this.trimSpaces != null) {
            this.serializer.setTrimSpaces(this.trimSpaces.booleanValue());
        }
        if (this.skipNamespaces != null) {
            this.serializer.setSkipNamespaces(this.skipNamespaces.booleanValue());
        }
        if (this.removeNamespacePrefixes != null) {
            this.serializer.setRemoveNamespacePrefixFromElements(this.removeNamespacePrefixes.booleanValue());
        }
        if (this.typeHints == TypeHintsEnum.YES || this.typeHints == TypeHintsEnum.WITH_PREFIX) {
            this.serializer.setTypeHintsEnabled(true);
            if (this.typeHints == TypeHintsEnum.WITH_PREFIX) {
                this.serializer.setTypeHintsCompatibility(false);
            } else {
                this.serializer.setTypeHintsCompatibility(true);
            }
        } else {
            this.serializer.setTypeHintsEnabled(false);
            this.serializer.setTypeHintsCompatibility(false);
        }
    }

    protected void doStop() throws Exception {
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Object xml;
        boolean streamTreatment = true;
        Object object = xml = graph instanceof String ? null : (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, graph);
        if (xml == null) {
            xml = exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, graph);
            streamTreatment = false;
        }
        JSON json = streamTreatment ? this.serializer.readFromStream((InputStream)xml) : this.serializer.read((String)xml);
        String encoding = IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
        if (encoding == null) {
            encoding = this.getEncoding();
        }
        OutputStreamWriter osw = null;
        osw = encoding != null ? new OutputStreamWriter(stream, encoding) : new OutputStreamWriter(stream);
        json.write((Writer)osw);
        osw.flush();
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        JSON toConvert;
        Object inBody = exchange.getIn().getBody();
        if (inBody instanceof JSON) {
            toConvert = (JSON)inBody;
        } else {
            String jsonString = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, inBody);
            toConvert = JSONSerializer.toJSON((Object)jsonString);
        }
        return this.convertToXMLUsingEncoding(toConvert);
    }

    private String convertToXMLUsingEncoding(JSON json) {
        if (this.encoding == null) {
            return this.serializer.write(json);
        }
        return this.serializer.write(json, this.encoding);
    }

    public XMLSerializer getSerializer() {
        return this.serializer;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getForceTopLevelObject() {
        return this.forceTopLevelObject;
    }

    public void setForceTopLevelObject(Boolean forceTopLevelObject) {
        this.forceTopLevelObject = forceTopLevelObject;
    }

    public Boolean getNamespaceLenient() {
        return this.namespaceLenient;
    }

    public void setNamespaceLenient(Boolean namespaceLenient) {
        this.namespaceLenient = namespaceLenient;
    }

    public List<NamespacesPerElementMapping> getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public void setNamespaceMappings(List<NamespacesPerElementMapping> namespaceMappings) {
        this.namespaceMappings = namespaceMappings;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public Boolean getSkipWhitespace() {
        return this.skipWhitespace;
    }

    public void setSkipWhitespace(Boolean skipWhitespace) {
        this.skipWhitespace = skipWhitespace;
    }

    public Boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(Boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }

    public TypeHintsEnum getTypeHints() {
        return this.typeHints;
    }

    public void setTypeHints(String typeHints) {
        this.typeHints = TypeHintsEnum.valueOf(typeHints);
    }

    public Boolean getSkipNamespaces() {
        return this.skipNamespaces;
    }

    public void setSkipNamespaces(Boolean skipNamespaces) {
        this.skipNamespaces = skipNamespaces;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setArrayName(String arrayName) {
        this.arrayName = arrayName;
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public void setExpandableProperties(List<String> expandableProperties) {
        this.expandableProperties = expandableProperties;
    }

    public List<String> getExpandableProperties() {
        return this.expandableProperties;
    }

    public void setRemoveNamespacePrefixes(Boolean removeNamespacePrefixes) {
        this.removeNamespacePrefixes = removeNamespacePrefixes;
    }

    public Boolean getRemoveNamespacePrefixes() {
        return this.removeNamespacePrefixes;
    }

    public static class NamespacesPerElementMapping {
        public String element;
        public Map<String, String> namespaces;

        public NamespacesPerElementMapping(String element, Map<String, String> namespaces) {
            this.element = element;
            this.namespaces = namespaces;
        }

        public NamespacesPerElementMapping(String element, String prefix, String uri) {
            this.element = element;
            this.namespaces = new HashMap<String, String>();
            this.namespaces.put(prefix, uri);
        }

        public NamespacesPerElementMapping(String element, String pipeSeparatedMappings) {
            this.element = element;
            this.namespaces = new HashMap<String, String>();
            String[] origTokens = pipeSeparatedMappings.split("\\|");
            String[] tokens = Arrays.copyOfRange(origTokens, 1, origTokens.length);
            if (tokens.length % 2 != 0) {
                throw new IllegalArgumentException("Even number of prefix-namespace tokens is expected, number of tokens parsed: " + tokens.length);
            }
            for (int i = 0; i < tokens.length - 1; ++i) {
                this.namespaces.put(tokens[i], tokens[++i]);
            }
        }
    }
}

