/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.TrustManager;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConversionException;
import org.apache.camel.component.rabbitmq.ArgsConfigurer;
import org.apache.camel.component.rabbitmq.RabbitMQComponent;
import org.apache.camel.component.rabbitmq.RabbitMQConsumer;
import org.apache.camel.component.rabbitmq.RabbitMQMessageConverter;
import org.apache.camel.component.rabbitmq.RabbitMQProducer;
import org.apache.camel.component.rabbitmq.ReplyToType;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="rabbitmq", title="RabbitMQ", syntax="rabbitmq:hostname:portNumber/exchangeName", consumerClass=RabbitMQConsumer.class, label="messaging")
public class RabbitMQEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitMQEndpoint.class);
    private static final String SERIALIZE_HEADER = "CamelSerialize";
    @UriPath
    @Metadata(required="true")
    private String hostname;
    @UriPath(defaultValue="5672")
    @Metadata(required="true")
    private int portNumber;
    @UriPath
    @Metadata(required="true")
    private String exchangeName;
    @UriParam(defaultValue="guest")
    private String username = "guest";
    @UriParam(defaultValue="guest")
    private String password = "guest";
    @UriParam(defaultValue="/")
    private String vhost = "/";
    @UriParam(label="consumer", defaultValue="10")
    private int threadPoolSize = 10;
    @UriParam(label="consumer", defaultValue="true")
    private boolean autoAck = true;
    @UriParam(defaultValue="true")
    private boolean autoDelete = true;
    @UriParam(defaultValue="true")
    private boolean durable = true;
    @UriParam(label="producer")
    private boolean bridgeEndpoint;
    @UriParam
    private String queue = String.valueOf(UUID.randomUUID().toString().hashCode());
    @UriParam(defaultValue="direct", enums="direct,fanout,headers,topic")
    private String exchangeType = "direct";
    @UriParam
    private String routingKey;
    @UriParam(label="producer")
    private boolean skipQueueDeclare;
    @UriParam
    private Address[] addresses;
    @UriParam(defaultValue="0")
    private int connectionTimeout = 0;
    @UriParam(defaultValue="0")
    private int requestedChannelMax = 0;
    @UriParam(defaultValue="0")
    private int requestedFrameMax = 0;
    @UriParam(defaultValue="0")
    private int requestedHeartbeat = 0;
    @UriParam
    private String sslProtocol;
    @UriParam
    private TrustManager trustManager;
    @UriParam
    private Map<String, Object> clientProperties;
    @UriParam
    private ConnectionFactory connectionFactory;
    @UriParam
    private Boolean automaticRecoveryEnabled;
    @UriParam
    private Integer networkRecoveryInterval;
    @UriParam
    private Boolean topologyRecoveryEnabled;
    @UriParam(label="consumer")
    private boolean prefetchEnabled;
    @UriParam(label="consumer")
    private int prefetchSize;
    @UriParam(label="consumer")
    private int prefetchCount;
    @UriParam(label="consumer")
    private boolean prefetchGlobal;
    @UriParam(label="consumer", defaultValue="1")
    private int concurrentConsumers = 1;
    @UriParam(defaultValue="true")
    private boolean declare = true;
    @UriParam
    private String deadLetterExchange;
    @UriParam
    private String deadLetterRoutingKey;
    @UriParam
    private String deadLetterQueue;
    @UriParam(defaultValue="direct", enums="direct,fanout,headers,topic")
    private String deadLetterExchangeType = "direct";
    @UriParam(label="producer", defaultValue="10")
    private int channelPoolMaxSize = 10;
    @UriParam(label="producer", defaultValue="1000")
    private long channelPoolMaxWait = 1000L;
    @UriParam(label="producer")
    private boolean mandatory;
    @UriParam(label="producer")
    private boolean immediate;
    @UriParam
    private ArgsConfigurer queueArgsConfigurer;
    @UriParam
    private ArgsConfigurer exchangeArgsConfigurer;
    @UriParam
    private long requestTimeout = 20000L;
    @UriParam
    private long requestTimeoutCheckerInterval = 1000L;
    @UriParam
    private boolean transferException;
    private boolean useMessageIDAsCorrelationID = true;
    private String replyToType = ReplyToType.Temporary.name();
    private String replyTo;
    private RabbitMQMessageConverter messageConverter = new RabbitMQMessageConverter();

    public RabbitMQEndpoint() {
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
    }

    public RabbitMQEndpoint(String endpointUri, RabbitMQComponent component, ConnectionFactory connectionFactory) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.connectionFactory = connectionFactory;
    }

    public Exchange createRabbitExchange(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        Exchange exchange = super.createExchange();
        this.setRabbitExchange(exchange, envelope, properties, body);
        return exchange;
    }

    protected RabbitMQMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setRabbitExchange(Exchange camelExchange, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        Map headers;
        Message message;
        if (camelExchange.getIn() != null) {
            message = camelExchange.getIn();
        } else {
            message = new DefaultMessage();
            camelExchange.setIn(message);
        }
        if (envelope != null) {
            message.setHeader("rabbitmq.ROUTING_KEY", (Object)envelope.getRoutingKey());
            message.setHeader("rabbitmq.EXCHANGE_NAME", (Object)envelope.getExchange());
            message.setHeader("rabbitmq.DELIVERY_TAG", (Object)envelope.getDeliveryTag());
        }
        if ((headers = properties.getHeaders()) != null) {
            for (Map.Entry entry : headers.entrySet()) {
                if (entry.getValue() instanceof LongString) {
                    message.setHeader((String)entry.getKey(), (Object)entry.getValue().toString());
                    continue;
                }
                message.setHeader((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.hasSerializeHeader(properties)) {
            Object messageBody = null;
            try (ByteArrayInputStream b = new ByteArrayInputStream(body);
                 ObjectInputStream o = new ObjectInputStream(b);){
                messageBody = o.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                LOG.warn("Could not deserialize the object");
            }
            if (messageBody instanceof Throwable) {
                LOG.debug("Reply was an Exception. Setting the Exception on the Exchange");
                camelExchange.setException((Throwable)messageBody);
            } else {
                message.setBody(messageBody);
            }
        } else {
            message.setBody((Object)body);
        }
    }

    private boolean hasSerializeHeader(AMQP.BasicProperties properties) {
        if (properties == null || properties.getHeaders() == null) {
            return false;
        }
        return properties.getHeaders().containsKey(SERIALIZE_HEADER) && properties.getHeaders().get(SERIALIZE_HEADER).equals(true);
    }

    public void publishExchangeToChannel(Exchange camelExchange, Channel channel, String routingKey) throws IOException {
        AMQP.BasicProperties properties;
        byte[] body;
        Message msg = camelExchange.hasOut() ? camelExchange.getOut() : camelExchange.getIn();
        if (msg.getHeaders() != null && msg.getHeaders().containsKey(SERIALIZE_HEADER)) {
            LOG.debug("Removing the {} header", (Object)SERIALIZE_HEADER);
            msg.getHeaders().remove(SERIALIZE_HEADER);
        }
        try {
            body = (byte[])camelExchange.getContext().getTypeConverter().mandatoryConvertTo(byte[].class, camelExchange, msg.getBody());
            properties = this.getMessageConverter().buildProperties(camelExchange).build();
        }
        catch (NoTypeConversionAvailableException | TypeConversionException e) {
            if (msg.getBody() instanceof Serializable) {
                msg.getHeaders().put(SERIALIZE_HEADER, true);
                properties = this.getMessageConverter().buildProperties(camelExchange).build();
                try (ByteArrayOutputStream b = new ByteArrayOutputStream();
                     ObjectOutputStream o = new ObjectOutputStream(b);){
                    o.writeObject(msg.getBody());
                    body = b.toByteArray();
                }
                catch (NotSerializableException nse) {
                    LOG.warn("Can not send object " + msg.getBody().getClass() + " via RabbitMQ because it contains non-serializable objects.");
                    throw new RuntimeCamelException(e);
                }
            }
            if (msg.getBody() == null) {
                properties = this.getMessageConverter().buildProperties(camelExchange).build();
                body = null;
            }
            LOG.warn("Could not convert {} to byte[]", msg.getBody());
            throw new RuntimeCamelException(e);
        }
        String rabbitExchange = this.getExchangeName(msg);
        Boolean mandatory = (Boolean)camelExchange.getIn().getHeader("rabbitmq.MANDATORY", (Object)this.isMandatory(), Boolean.class);
        Boolean immediate = (Boolean)camelExchange.getIn().getHeader("rabbitmq.IMMEDIATE", (Object)this.isImmediate(), Boolean.class);
        LOG.debug("Sending message to exchange: {} with CorrelationId = {}", (Object)rabbitExchange, (Object)properties.getCorrelationId());
        channel.basicPublish(rabbitExchange, routingKey, mandatory.booleanValue(), immediate.booleanValue(), properties, body);
    }

    protected String getExchangeName(Message msg) {
        String exchangeName = (String)msg.getHeader("rabbitmq.EXCHANGE_NAME", String.class);
        if (exchangeName == null || this.isBridgeEndpoint()) {
            exchangeName = this.getExchangeName();
        }
        return exchangeName;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RabbitMQConsumer consumer = new RabbitMQConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Connection connect(ExecutorService executor) throws IOException, TimeoutException {
        if (this.getAddresses() == null) {
            return this.getOrCreateConnectionFactory().newConnection(executor);
        }
        return this.getOrCreateConnectionFactory().newConnection(executor, this.getAddresses());
    }

    public void declareExchangeAndQueue(Channel channel) throws IOException {
        HashMap<String, Object> queueArgs = new HashMap<String, Object>();
        HashMap<String, Object> exchangeArgs = new HashMap<String, Object>();
        if (this.deadLetterExchange != null) {
            queueArgs.put("x-dead-letter-exchange", this.getDeadLetterExchange());
            queueArgs.put("x-dead-letter-routing-key", this.getDeadLetterRoutingKey());
            channel.exchangeDeclare(this.getDeadLetterExchange(), this.getDeadLetterExchangeType(), this.isDurable(), this.isAutoDelete(), new HashMap());
            channel.queueDeclare(this.getDeadLetterQueue(), this.isDurable(), false, this.isAutoDelete(), null);
            channel.queueBind(this.getDeadLetterQueue(), this.getDeadLetterExchange(), this.getDeadLetterRoutingKey() == null ? "" : this.getDeadLetterRoutingKey());
        }
        if (this.getQueueArgsConfigurer() != null) {
            this.getQueueArgsConfigurer().configurArgs(queueArgs);
        }
        if (this.getExchangeArgsConfigurer() != null) {
            this.getExchangeArgsConfigurer().configurArgs(exchangeArgs);
        }
        channel.exchangeDeclare(this.getExchangeName(), this.getExchangeType(), this.isDurable(), this.isAutoDelete(), exchangeArgs);
        if (!this.isSkipQueueDeclare() && this.getQueue() != null) {
            channel.queueDeclare(this.getQueue(), this.isDurable(), false, this.isAutoDelete(), queueArgs);
            channel.queueBind(this.getQueue(), this.getExchangeName(), this.getRoutingKey() == null ? "" : this.getRoutingKey());
        }
    }

    private ConnectionFactory getOrCreateConnectionFactory() {
        if (this.connectionFactory == null) {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setUsername(this.getUsername());
            factory.setPassword(this.getPassword());
            factory.setVirtualHost(this.getVhost());
            factory.setHost(this.getHostname());
            factory.setPort(this.getPortNumber());
            if (this.getClientProperties() != null) {
                factory.setClientProperties(this.getClientProperties());
            }
            factory.setConnectionTimeout(this.getConnectionTimeout());
            factory.setRequestedChannelMax(this.getRequestedChannelMax());
            factory.setRequestedFrameMax(this.getRequestedFrameMax());
            factory.setRequestedHeartbeat(this.getRequestedHeartbeat());
            if (this.getSslProtocol() != null) {
                try {
                    if (this.getSslProtocol().equals("true")) {
                        factory.useSslProtocol();
                    } else if (this.getTrustManager() == null) {
                        factory.useSslProtocol(this.getSslProtocol());
                    } else {
                        factory.useSslProtocol(this.getSslProtocol(), this.getTrustManager());
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Invalid sslProtocol " + this.sslProtocol, e);
                }
                catch (KeyManagementException e) {
                    throw new IllegalArgumentException("Invalid sslProtocol " + this.sslProtocol, e);
                }
            }
            if (this.getAutomaticRecoveryEnabled() != null) {
                factory.setAutomaticRecoveryEnabled(this.getAutomaticRecoveryEnabled().booleanValue());
            }
            if (this.getNetworkRecoveryInterval() != null) {
                factory.setNetworkRecoveryInterval(this.getNetworkRecoveryInterval().intValue());
            }
            if (this.getTopologyRecoveryEnabled() != null) {
                factory.setTopologyRecoveryEnabled(this.getTopologyRecoveryEnabled().booleanValue());
            }
            this.connectionFactory = factory;
        }
        return this.connectionFactory;
    }

    public Producer createProducer() throws Exception {
        return new RabbitMQProducer(this);
    }

    public boolean isSingleton() {
        return true;
    }

    protected ExecutorService createExecutor() {
        if (this.getCamelContext() != null) {
            return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "RabbitMQConsumer", this.getThreadPoolSize());
        }
        return Executors.newFixedThreadPool(this.getThreadPoolSize());
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVhost() {
        return this.vhost;
    }

    public void setVhost(String vhost) {
        this.vhost = vhost;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setSkipQueueDeclare(boolean skipQueueDeclare) {
        this.skipQueueDeclare = skipQueueDeclare;
    }

    public boolean isSkipQueueDeclare() {
        return this.skipQueueDeclare;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setAddresses(String addresses) {
        Address[] addressArray = Address.parseAddresses((String)addresses);
        if (addressArray.length > 0) {
            this.addresses = addressArray;
        }
    }

    public Address[] getAddresses() {
        return this.addresses;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public Map<String, Object> getClientProperties() {
        return this.clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.clientProperties = clientProperties;
    }

    public Boolean getAutomaticRecoveryEnabled() {
        return this.automaticRecoveryEnabled;
    }

    public void setAutomaticRecoveryEnabled(Boolean automaticRecoveryEnabled) {
        this.automaticRecoveryEnabled = automaticRecoveryEnabled;
    }

    public Integer getNetworkRecoveryInterval() {
        return this.networkRecoveryInterval;
    }

    public void setNetworkRecoveryInterval(Integer networkRecoveryInterval) {
        this.networkRecoveryInterval = networkRecoveryInterval;
    }

    public Boolean getTopologyRecoveryEnabled() {
        return this.topologyRecoveryEnabled;
    }

    public void setTopologyRecoveryEnabled(Boolean topologyRecoveryEnabled) {
        this.topologyRecoveryEnabled = topologyRecoveryEnabled;
    }

    public boolean isPrefetchEnabled() {
        return this.prefetchEnabled;
    }

    public void setPrefetchEnabled(boolean prefetchEnabled) {
        this.prefetchEnabled = prefetchEnabled;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchGlobal(boolean prefetchGlobal) {
        this.prefetchGlobal = prefetchGlobal;
    }

    public boolean isPrefetchGlobal() {
        return this.prefetchGlobal;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public boolean isDeclare() {
        return this.declare;
    }

    public void setDeclare(boolean declare) {
        this.declare = declare;
    }

    public String getDeadLetterExchange() {
        return this.deadLetterExchange;
    }

    public void setDeadLetterExchange(String deadLetterExchange) {
        this.deadLetterExchange = deadLetterExchange;
    }

    public String getDeadLetterQueue() {
        return this.deadLetterQueue;
    }

    public void setDeadLetterQueue(String deadLetterQueue) {
        this.deadLetterQueue = deadLetterQueue;
    }

    public String getDeadLetterRoutingKey() {
        return this.deadLetterRoutingKey;
    }

    public void setDeadLetterRoutingKey(String deadLetterRoutingKey) {
        this.deadLetterRoutingKey = deadLetterRoutingKey;
    }

    public String getDeadLetterExchangeType() {
        return this.deadLetterExchangeType;
    }

    public void setDeadLetterExchangeType(String deadLetterExchangeType) {
        this.deadLetterExchangeType = deadLetterExchangeType;
    }

    public int getChannelPoolMaxSize() {
        return this.channelPoolMaxSize;
    }

    public void setChannelPoolMaxSize(int channelPoolMaxSize) {
        this.channelPoolMaxSize = channelPoolMaxSize;
    }

    public long getChannelPoolMaxWait() {
        return this.channelPoolMaxWait;
    }

    public void setChannelPoolMaxWait(long channelPoolMaxWait) {
        this.channelPoolMaxWait = channelPoolMaxWait;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public ArgsConfigurer getQueueArgsConfigurer() {
        return this.queueArgsConfigurer;
    }

    public void setQueueArgsConfigurer(ArgsConfigurer queueArgsConfigurer) {
        this.queueArgsConfigurer = queueArgsConfigurer;
    }

    public ArgsConfigurer getExchangeArgsConfigurer() {
        return this.exchangeArgsConfigurer;
    }

    public void setExchangeArgsConfigurer(ArgsConfigurer exchangeArgsConfigurer) {
        this.exchangeArgsConfigurer = exchangeArgsConfigurer;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public boolean isUseMessageIDAsCorrelationID() {
        return this.useMessageIDAsCorrelationID;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public String getReplyToType() {
        return this.replyToType;
    }

    public String getReplyTo() {
        return this.replyTo;
    }
}

