/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.linkedin.LinkedInConfiguration;
import org.apache.camel.component.linkedin.LinkedInEndpoint;
import org.apache.camel.component.linkedin.api.LinkedInOAuthRequestFilter;
import org.apache.camel.component.linkedin.api.OAuthParams;
import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.internal.CachingOAuthSecureStorage;
import org.apache.camel.component.linkedin.internal.LinkedInApiCollection;
import org.apache.camel.component.linkedin.internal.LinkedInApiName;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedInComponent
extends AbstractApiComponent<LinkedInApiName, LinkedInConfiguration, LinkedInApiCollection> {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedInComponent.class);
    private LinkedInOAuthRequestFilter requestFilter;

    public LinkedInComponent() {
        super(LinkedInEndpoint.class, LinkedInApiName.class, (ApiCollection)LinkedInApiCollection.getCollection());
    }

    public LinkedInComponent(CamelContext context) {
        super(context, LinkedInEndpoint.class, LinkedInApiName.class, (ApiCollection)LinkedInApiCollection.getCollection());
    }

    protected LinkedInApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return LinkedInApiName.fromValue(apiNameStr);
    }

    public void setConfiguration(LinkedInConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    protected Endpoint createEndpoint(String uri, String methodName, LinkedInApiName apiName, LinkedInConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new LinkedInEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public synchronized LinkedInOAuthRequestFilter getRequestFilter(LinkedInConfiguration endpointConfiguration) {
        if (endpointConfiguration.equals(this.configuration)) {
            if (this.requestFilter == null) {
                this.requestFilter = LinkedInComponent.createRequestFilter((LinkedInConfiguration)this.configuration);
            }
            return this.requestFilter;
        }
        return LinkedInComponent.createRequestFilter(endpointConfiguration);
    }

    private static LinkedInOAuthRequestFilter createRequestFilter(LinkedInConfiguration configuration) {
        String[] enabledProtocols;
        configuration.validate();
        try {
            SSLContext sslContext = new SSLContextParameters().createSSLContext();
            enabledProtocols = sslContext.createSSLEngine().getEnabledProtocols();
        }
        catch (GeneralSecurityException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        return new LinkedInOAuthRequestFilter(LinkedInComponent.getOAuthParams(configuration), configuration.getHttpParams(), configuration.isLazyAuth(), enabledProtocols);
    }

    private static OAuthParams getOAuthParams(LinkedInConfiguration configuration) {
        return new OAuthParams(configuration.getUserName(), configuration.getUserPassword(), (OAuthSecureStorage)new CachingOAuthSecureStorage(configuration.getSecureStorage()), configuration.getClientId(), configuration.getClientSecret(), configuration.getRedirectUri(), configuration.getScopes());
    }

    protected void doStop() throws Exception {
        if (this.requestFilter != null) {
            this.closeLogException(this.requestFilter);
        }
    }

    protected void closeRequestFilter(LinkedInOAuthRequestFilter requestFilter) {
        if (this.requestFilter != requestFilter) {
            this.closeLogException(requestFilter);
        }
    }

    private void closeLogException(LinkedInOAuthRequestFilter requestFilter) {
        try {
            requestFilter.close();
        }
        catch (Exception e) {
            LOG.warn("Error closing OAuth2 request filter: " + e.getMessage(), (Throwable)e);
        }
    }
}

