/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.util.ArrayList;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.elasticsearch.ElasticsearchComponent;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="elasticsearch", title="Elasticsearch", syntax="elasticsearch:clusterName", producerOnly=true, label="monitoring,search")
public class ElasticsearchEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchEndpoint.class);
    private Node node;
    private Client client;
    @UriParam
    private ElasticsearchConfiguration configuration;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, ElasticsearchConfiguration config) throws Exception {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from an ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.configuration.isLocal()) {
            LOG.info("Starting local ElasticSearch server");
        } else {
            LOG.info("Joining ElasticSearch cluster " + this.configuration.getClusterName());
        }
        if (this.configuration.getIp() != null) {
            this.client = new TransportClient(this.getSettings()).addTransportAddress((TransportAddress)new InetSocketTransportAddress(this.configuration.getIp(), this.configuration.getPort()));
        } else if (this.configuration.getTransportAddressesList() != null && !this.configuration.getTransportAddressesList().isEmpty()) {
            ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>(this.configuration.getTransportAddressesList().size());
            for (TransportAddress transportAddress : this.configuration.getTransportAddressesList()) {
                addresses.add(transportAddress);
            }
            this.client = new TransportClient(this.getSettings()).addTransportAddresses(addresses.toArray(new TransportAddress[addresses.size()]));
        } else {
            NodeBuilder builder = NodeBuilder.nodeBuilder().local(this.configuration.isLocal()).data(this.configuration.getData().booleanValue());
            if (!this.configuration.isLocal() && this.configuration.getClusterName() != null) {
                builder.clusterName(this.configuration.getClusterName());
            }
            builder.getSettings().classLoader(Settings.class.getClassLoader());
            this.node = builder.node();
            this.client = this.node.client();
        }
    }

    private Settings getSettings() {
        return ImmutableSettings.settingsBuilder().classLoader(Settings.class.getClassLoader()).put("cluster.name", this.configuration.getClusterName()).put("client.transport.ignore_cluster_name", false).put("node.client", true).put("client.transport.sniff", true).build();
    }

    protected void doStop() throws Exception {
        if (this.configuration.isLocal()) {
            LOG.info("Stopping local ElasticSearch server");
        } else {
            LOG.info("Leaving ElasticSearch cluster " + this.configuration.getClusterName());
        }
        this.client.close();
        if (this.node != null) {
            this.node.close();
        }
        super.doStop();
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticsearchConfiguration getConfig() {
        return this.configuration;
    }

    public void setOperation(String operation) {
        this.configuration.setOperation(operation);
    }
}

