/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elsql;

import com.opengamma.elsql.ElSql;
import com.opengamma.elsql.SpringSqlParams;
import com.opengamma.elsql.SqlParams;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.elsql.ElsqlEndpoint;
import org.apache.camel.component.elsql.ElsqlSqlMapSource;
import org.apache.camel.component.sql.SqlOutputType;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.JdbcUtils;

public class ElsqlProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElsqlProducer.class);
    private final ElSql elSql;
    private final String elSqlName;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public ElsqlProducer(ElsqlEndpoint endpoint, ElSql elSql, String elSqlName, NamedParameterJdbcTemplate jdbcTemplate) {
        super((Endpoint)endpoint);
        this.elSql = elSql;
        this.elSqlName = elSqlName;
        this.jdbcTemplate = jdbcTemplate;
    }

    public ElsqlEndpoint getEndpoint() {
        return (ElsqlEndpoint)super.getEndpoint();
    }

    public void process(final Exchange exchange) throws Exception {
        Object data = exchange.getIn().getBody();
        ElsqlSqlMapSource param = new ElsqlSqlMapSource(exchange, data);
        String sql = this.elSql.getSql(this.elSqlName, (SqlParams)new SpringSqlParams((SqlParameterSource)param));
        LOG.debug("ElsqlProducer @{} using sql: {}", (Object)this.elSqlName, (Object)sql);
        this.jdbcTemplate.execute(sql, (SqlParameterSource)param, (PreparedStatementCallback)new PreparedStatementCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                block18: {
                    ResultSet rs = null;
                    try {
                        boolean isResultSet = ps.execute();
                        if (!isResultSet) break block18;
                        rs = ps.getResultSet();
                        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                        SqlOutputType outputType = ElsqlProducer.this.getEndpoint().getOutputType();
                        ElsqlProducer.this.log.trace("Got result list from query: {}, outputType={}", (Object)rs, (Object)outputType);
                        if (outputType == SqlOutputType.SelectList) {
                            List data = ElsqlProducer.this.getEndpoint().queryForList(rs, true);
                            if (ElsqlProducer.this.getEndpoint().isNoop()) {
                                exchange.getOut().setBody(exchange.getIn().getBody());
                            } else if (ElsqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                exchange.getOut().setBody(exchange.getIn().getBody());
                                exchange.getOut().setHeader(ElsqlProducer.this.getEndpoint().getOutputHeader(), (Object)data);
                            } else {
                                exchange.getOut().setBody((Object)data);
                            }
                            exchange.getOut().setHeader("CamelSqlRowCount", (Object)data.size());
                            break block18;
                        }
                        if (outputType == SqlOutputType.SelectOne) {
                            Object data = ElsqlProducer.this.getEndpoint().queryForObject(rs);
                            if (data != null) {
                                if (ElsqlProducer.this.getEndpoint().isNoop()) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                } else if (ElsqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                    exchange.getOut().setHeader(ElsqlProducer.this.getEndpoint().getOutputHeader(), data);
                                } else {
                                    exchange.getOut().setBody(data);
                                }
                                exchange.getOut().setHeader("CamelSqlRowCount", (Object)1);
                            } else {
                                if (ElsqlProducer.this.getEndpoint().isNoop()) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                } else if (ElsqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                }
                                exchange.getOut().setHeader("CamelSqlRowCount", (Object)0);
                            }
                            break block18;
                        }
                        throw new IllegalArgumentException("Invalid outputType=" + outputType);
                    }
                    finally {
                        JdbcUtils.closeResultSet(rs);
                    }
                }
                return null;
            }
        });
    }
}

