/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hdfs;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.hdfs.HdfsConfiguration;
import org.apache.camel.component.hdfs.HdfsConsumer;
import org.apache.camel.component.hdfs.HdfsProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="hdfs", title="HDFS", syntax="hdfs:hostName:port/path", consumerClass=HdfsConsumer.class, label="hadoop,file")
public class HdfsEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private final HdfsConfiguration config = new HdfsConfiguration();

    public HdfsEndpoint(String endpointUri, CamelContext context) throws URISyntaxException {
        super(endpointUri, context);
        this.config.parseURI(new URI(endpointUri));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.config.checkConsumerOptions();
        HdfsConsumer answer = new HdfsConsumer(this, processor, this.config);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() {
        this.config.checkProducerOptions();
        return new HdfsProducer(this, this.config);
    }

    public boolean isSingleton() {
        return true;
    }

    public HdfsConfiguration getConfig() {
        return this.config;
    }
}

