/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.consumer;

import com.github.dockerjava.api.command.StatsCallback;
import com.github.dockerjava.api.command.StatsCmd;
import com.github.dockerjava.api.model.Statistics;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerStatsConsumer
extends DefaultConsumer
implements StatsCallback {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(DockerStatsConsumer.class);
    private DockerEndpoint endpoint;
    private DockerComponent component;
    private StatsCmd statsCmd;
    private ExecutorService eventsExecutorService;

    public DockerStatsConsumer(DockerEndpoint endpoint, Processor processor) throws Exception {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public DockerEndpoint getEndpoint() {
        return (DockerEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.statsCmd = DockerClientFactory.getDockerClient(this.component, this.endpoint.getConfiguration(), null).statsCmd((StatsCallback)this);
        String containerId = DockerHelper.getProperty("CamelDockerContainerId", this.endpoint.getConfiguration(), null, String.class);
        this.statsCmd.withContainerId(containerId);
        this.eventsExecutorService = (ExecutorService)this.statsCmd.exec();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.eventsExecutorService != null && !this.eventsExecutorService.isTerminated()) {
            LOGGER.trace("Stopping Docker statistics Executor Service");
            this.eventsExecutorService.shutdown();
        }
        super.doStop();
    }

    public void onStats(Statistics statistics) {
        LOGGER.debug("Received Docker Statistics Event: " + statistics);
        final Exchange exchange = this.getEndpoint().createExchange();
        Message message = exchange.getIn();
        message.setBody((Object)statistics);
        try {
            LOGGER.trace("Processing exchange [{}]...", (Object)exchange);
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    LOGGER.trace("Done processing exchange [{}]...", (Object)exchange);
                }
            });
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
    }

    public void onException(Throwable throwable) {
        LOGGER.error("Error Consuming from Docker Statistics: {}", (Object)throwable.getMessage());
    }

    public void onCompletion(int numEvents) {
        LOGGER.debug("Docker statistics connection completed. Events processed : {}", (Object)numEvents);
        this.statsCmd.exec();
    }

    public boolean isReceiving() {
        return this.isRunAllowed();
    }
}

