/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.StartupListener;
import org.apache.camel.component.quickfixj.QuickfixjConfiguration;
import org.apache.camel.component.quickfixj.QuickfixjEndpoint;
import org.apache.camel.component.quickfixj.QuickfixjEngine;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SessionSettings;

public class QuickfixjComponent
extends UriEndpointComponent
implements StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjComponent.class);
    private static final String PARAMETER_LAZY_CREATE_ENGINE = "lazyCreateEngine";
    private final Object engineInstancesLock = new Object();
    private final Map<String, QuickfixjEngine> engines = new HashMap<String, QuickfixjEngine>();
    private final Map<String, QuickfixjEngine> provisionalEngines = new HashMap<String, QuickfixjEngine>();
    private final Map<String, QuickfixjEndpoint> endpoints = new HashMap<String, QuickfixjEndpoint>();
    private MessageStoreFactory messageStoreFactory;
    private LogFactory logFactory;
    private MessageFactory messageFactory;
    private Map<String, QuickfixjConfiguration> configurations = new HashMap<String, QuickfixjConfiguration>();
    private boolean lazyCreateEngines;

    public QuickfixjComponent() {
        super(QuickfixjEndpoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Object object = this.engineInstancesLock;
        synchronized (object) {
            QuickfixjEndpoint endpoint = this.endpoints.get(uri);
            if (endpoint == null) {
                QuickfixjEngine engine = this.engines.get(remaining);
                if (engine == null) {
                    engine = this.provisionalEngines.get(remaining);
                }
                if (engine == null) {
                    QuickfixjConfiguration configuration = this.configurations.get(remaining);
                    SessionSettings settings = configuration != null ? configuration.createSessionSettings() : QuickfixjEngine.loadSettings(remaining);
                    Boolean lazyCreateEngineForEndpoint = (Boolean)super.getAndRemoveParameter(parameters, PARAMETER_LAZY_CREATE_ENGINE, Boolean.TYPE);
                    if (lazyCreateEngineForEndpoint == null) {
                        lazyCreateEngineForEndpoint = this.isLazyCreateEngines();
                    }
                    engine = new QuickfixjEngine(uri, settings, this.messageStoreFactory, this.logFactory, this.messageFactory, lazyCreateEngineForEndpoint);
                    if (this.getCamelContext().getStatus().isStarted()) {
                        this.startQuickfixjEngine(engine);
                        this.engines.put(remaining, engine);
                    } else {
                        this.provisionalEngines.put(remaining, engine);
                    }
                }
                endpoint = new QuickfixjEndpoint(engine, uri, (Component)this);
                endpoint.setConfigurationName(remaining);
                endpoint.setLazyCreateEngine(engine.isLazy());
                engine.addEventListener(endpoint);
                this.endpoints.put(uri, endpoint);
            }
            return endpoint;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        Object object = this.engineInstancesLock;
        synchronized (object) {
            for (QuickfixjEngine engine : this.engines.values()) {
                engine.stop();
            }
        }
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        this.engines.clear();
        this.provisionalEngines.clear();
        this.endpoints.clear();
        super.doShutdown();
    }

    private void startQuickfixjEngine(QuickfixjEngine engine) throws Exception {
        if (!engine.isLazy()) {
            LOG.info("Starting QuickFIX/J engine: {}", (Object)engine.getUri());
            engine.start();
        } else {
            LOG.info("QuickFIX/J engine: {} will start lazily", (Object)engine.getUri());
        }
    }

    Map<String, QuickfixjEngine> getEngines() {
        return Collections.unmodifiableMap(this.engines);
    }

    Map<String, QuickfixjEngine> getProvisionalEngines() {
        return Collections.unmodifiableMap(this.provisionalEngines);
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setLogFactory(LogFactory logFactory) {
        this.logFactory = logFactory;
    }

    public void setMessageStoreFactory(MessageStoreFactory messageStoreFactory) {
        this.messageStoreFactory = messageStoreFactory;
    }

    public Map<String, QuickfixjConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Map<String, QuickfixjConfiguration> configurations) {
        this.configurations = configurations;
    }

    public boolean isLazyCreateEngines() {
        return this.lazyCreateEngines;
    }

    public void setLazyCreateEngines(boolean lazyCreateEngines) {
        this.lazyCreateEngines = lazyCreateEngines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCamelContextStarted(CamelContext camelContext, boolean alreadyStarted) throws Exception {
        Object object = this.engineInstancesLock;
        synchronized (object) {
            for (QuickfixjEngine quickfixjEngine : this.engines.values()) {
                this.startQuickfixjEngine(quickfixjEngine);
            }
            for (Map.Entry entry : this.provisionalEngines.entrySet()) {
                this.startQuickfixjEngine((QuickfixjEngine)((Object)entry.getValue()));
                this.engines.put((String)entry.getKey(), (QuickfixjEngine)((Object)entry.getValue()));
            }
            this.provisionalEngines.clear();
        }
    }
}

