/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gora;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.gora.GoraComponent;
import org.apache.camel.component.gora.GoraConfiguration;
import org.apache.camel.component.gora.GoraConsumer;
import org.apache.camel.component.gora.GoraProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="gora", title="Gora", syntax="gora:name", consumerClass=GoraConsumer.class, label="database,hadoop,nosql")
public class GoraEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(GoraEndpoint.class);
    private final DataStore<Object, Persistent> dataStore;
    @UriParam
    private GoraConfiguration configuration;

    public GoraEndpoint(String uri, GoraComponent goraComponent, GoraConfiguration config, DataStore<Object, Persistent> dataStore) {
        super(uri, (Component)goraComponent);
        this.configuration = config;
        this.dataStore = dataStore;
    }

    public Producer createProducer() throws Exception {
        return new GoraProducer((Endpoint)this, this.configuration, this.dataStore);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new GoraConsumer((Endpoint)this, processor, this.configuration, this.dataStore);
    }

    public GoraConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isSingleton() {
        return true;
    }
}

