/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.impl.DefaultProducer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanProducer
extends DefaultProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanProducer.class);
    private final InfinispanConfiguration configuration;
    private BasicCacheContainer cacheContainer;
    private boolean isManagedCacheContainer;

    public InfinispanProducer(InfinispanEndpoint endpoint, InfinispanConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
    }

    public void process(Exchange exchange) throws Exception {
        new InfinispanOperation(this.getCache(exchange), this.configuration).process(exchange);
    }

    protected void doStart() throws Exception {
        this.cacheContainer = this.configuration.getCacheContainer();
        if (this.cacheContainer == null) {
            Configuration config = new ConfigurationBuilder().classLoader(Thread.currentThread().getContextClassLoader()).addServers(this.configuration.getHost()).build();
            this.cacheContainer = new RemoteCacheManager(config, true);
            this.isManagedCacheContainer = true;
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.isManagedCacheContainer) {
            this.cacheContainer.stop();
        }
        super.doStop();
    }

    private BasicCache<Object, Object> getCache(Exchange exchange) {
        String cacheName = (String)exchange.getIn().getHeader("CamelInfinispanCacheName", String.class);
        if (cacheName == null) {
            cacheName = this.configuration.getCacheName();
        }
        LOGGER.trace("Cache[{}]", (Object)cacheName);
        return cacheName != null ? this.cacheContainer.getCache(cacheName) : this.cacheContainer.getCache();
    }
}

