/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.infinispan.InfinispanAsyncEventListener;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanProducer;
import org.apache.camel.component.infinispan.InfinispanSyncEventListener;
import org.apache.camel.impl.DefaultConsumer;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanProducer.class);
    private final InfinispanConfiguration configuration;
    private final InfinispanSyncEventListener listener;
    private EmbeddedCacheManager cacheManager;

    public InfinispanConsumer(InfinispanEndpoint endpoint, Processor processor, InfinispanConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.configuration = configuration;
        this.listener = configuration.isSync() ? new InfinispanSyncEventListener(this, configuration.getEventTypes()) : new InfinispanAsyncEventListener(this, configuration.getEventTypes());
    }

    public void processEvent(String eventType, boolean isPre, String cacheName, Object key) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getOut().setHeader("CamelInfinispanEventType", (Object)eventType);
        exchange.getOut().setHeader("CamelInfinispanIsPre", (Object)isPre);
        exchange.getOut().setHeader("CamelInfinispanCacheName", (Object)cacheName);
        exchange.getOut().setHeader("CamelInfinispanKey", key);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOGGER.error("Error processing event ", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (!(this.configuration.getCacheContainer() instanceof EmbeddedCacheManager)) {
            throw new UnsupportedOperationException("Consumer not support for CacheContainer: " + this.configuration.getCacheContainer());
        }
        this.cacheManager = (EmbeddedCacheManager)this.configuration.getCacheContainer();
        Cache cache = this.configuration.getCacheName() != null ? this.cacheManager.getCache(this.configuration.getCacheName()) : this.cacheManager.getCache();
        cache.addListener((Object)this.listener);
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.cacheManager != null) {
            this.cacheManager.removeListener((Object)this.listener);
        }
        super.doStop();
    }
}

