/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestCommentProducer
extends AbstractGitHubProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestCommentProducer.class);
    private PullRequestService pullRequestService;
    private IssueService issueService;

    public PullRequestCommentProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry " + service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService((GitHubService)this.pullRequestService);
        service = registry.lookupByName("githbIssueService");
        this.issueService = service != null ? (IssueService)service : new IssueService();
        this.initService((GitHubService)this.issueService);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Integer pullRequestNumber = (Integer)exchange.getIn().getHeader("GitHubPullRequest", Integer.class);
        Integer inResponseTo = (Integer)exchange.getIn().getHeader("GitHubInResponseTo", Integer.class);
        String text = (String)exchange.getIn().getBody(String.class);
        Object response = inResponseTo != null && inResponseTo > 0 ? this.pullRequestService.replyToComment((IRepositoryIdProvider)this.getRepository(), pullRequestNumber.intValue(), inResponseTo.intValue(), text) : this.issueService.createComment((IRepositoryIdProvider)this.getRepository(), pullRequestNumber.intValue(), text);
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(response);
        }
    }
}

