/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.sns;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws.sns.SnsConfiguration;
import org.apache.camel.component.aws.sns.SnsEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class SnsComponent
extends UriEndpointComponent {
    public SnsComponent() {
        super(SnsEndpoint.class);
    }

    public SnsComponent(CamelContext context) {
        super(context, SnsEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SnsConfiguration configuration = new SnsConfiguration();
        this.setProperties(configuration, parameters);
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Topic name must be specified.");
        }
        configuration.setTopicName(remaining);
        if (configuration.getAmazonSNSClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSNSClient or accessKey and secretKey must be specified");
        }
        SnsEndpoint endpoint = new SnsEndpoint(uri, (Component)this, configuration);
        return endpoint;
    }
}

