/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ddb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.aws.ddb.AbstractDdbCommand;
import org.apache.camel.component.aws.ddb.DdbConfiguration;

public class ScanCommand
extends AbstractDdbCommand {
    public ScanCommand(AmazonDynamoDB ddbClient, DdbConfiguration configuration, Exchange exchange) {
        super(ddbClient, configuration, exchange);
    }

    @Override
    public void execute() {
        ScanResult result = this.ddbClient.scan(new ScanRequest().withTableName(this.determineTableName()).withScanFilter(this.determineScanFilter()));
        this.addToResult("CamelAwsDdbItems", result.getItems());
        this.addToResult("CamelAwsDdbLastEvaluatedKey", result.getLastEvaluatedKey());
        this.addToResult("CamelAwsDdbConsumedCapacity", result.getConsumedCapacity());
        this.addToResult("CamelAwsDdbCount", result.getCount());
        this.addToResult("CamelAwsDdbScannedCount", result.getScannedCount());
    }

    private Map<String, Condition> determineScanFilter() {
        return (Map)this.exchange.getIn().getHeader("CamelAwsDdbScanFilter", Map.class);
    }
}

