/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kestrel;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.MemcachedClient;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.kestrel.KestrelEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.ShutdownAware;

public class KestrelConsumer
extends DefaultConsumer
implements ShutdownAware {
    private final KestrelEndpoint endpoint;
    private final MemcachedClient memcachedClient;
    private final BlockingQueue<Exchanger<?>> exchangerQueue = new LinkedBlockingQueue();
    private ExecutorService pollerExecutor;
    private ExecutorService handlerExecutor;
    private volatile boolean shutdownPending;
    private CountDownLatch shutdownLatch;
    private AtomicInteger pendingExchangeCount = new AtomicInteger(0);

    public KestrelConsumer(KestrelEndpoint endpoint, Processor processor, MemcachedClient memcachedClient) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.memcachedClient = memcachedClient;
    }

    protected void doStart() throws Exception {
        this.log.info("Starting consumer for " + this.endpoint.getEndpointUri());
        int poolSize = this.endpoint.getConfiguration().getConcurrentConsumers();
        this.shutdownPending = false;
        if (poolSize > 1) {
            this.shutdownLatch = new CountDownLatch(poolSize + 1);
            this.handlerExecutor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "Handlers-" + this.endpoint.getEndpointUri(), poolSize);
            for (int k = 0; k < poolSize; ++k) {
                this.handlerExecutor.execute(new Handler());
            }
        } else {
            this.shutdownLatch = new CountDownLatch(1);
        }
        this.pollerExecutor = this.endpoint.getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, "Poller-" + this.endpoint.getEndpointUri());
        this.pollerExecutor.submit(new Poller(poolSize > 1));
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.info("Stopping consumer for " + this.endpoint.getEndpointUri());
        if (this.pollerExecutor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.pollerExecutor);
            this.pollerExecutor = null;
        }
        if (this.handlerExecutor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.handlerExecutor);
            this.handlerExecutor = null;
        }
        super.doStop();
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return false;
    }

    public int getPendingExchangesSize() {
        return this.pendingExchangeCount.get();
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        this.shutdownPending = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Preparing to shutdown, waiting for {} threads to complete.", (Object)this.shutdownLatch.getCount());
        }
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final class Handler
    implements Runnable {
        private Exchanger<Handler> exchanger = new Exchanger();

        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (KestrelConsumer.this.log.isTraceEnabled()) {
                KestrelConsumer.this.log.trace("{} is starting", (Object)Thread.currentThread().getName());
            }
            while (KestrelConsumer.this.isRunAllowed() && !KestrelConsumer.this.shutdownPending) {
                Handler value;
                try {
                    KestrelConsumer.this.exchangerQueue.put(this.exchanger);
                }
                catch (InterruptedException e) {
                    if (!KestrelConsumer.this.log.isDebugEnabled()) continue;
                    KestrelConsumer.this.log.debug("Interrupted, are we stopping? {}", (Object)(KestrelConsumer.this.isStopping() || KestrelConsumer.this.isStopped() ? 1 : 0));
                    continue;
                }
                KestrelConsumer.this.pendingExchangeCount.incrementAndGet();
                try {
                    value = this.exchanger.exchange(this);
                }
                catch (InterruptedException e) {
                    if (KestrelConsumer.this.log.isDebugEnabled()) {
                        KestrelConsumer.this.log.debug("Interrupted, are we stopping? {}", (Object)(KestrelConsumer.this.isStopping() || KestrelConsumer.this.isStopped() ? 1 : 0));
                    }
                    KestrelConsumer.this.pendingExchangeCount.decrementAndGet();
                    continue;
                }
                try {
                    KestrelConsumer.this.log.trace("Got a value from the exchanger");
                    Exchange exchange = null;
                    try {
                        exchange = KestrelConsumer.this.endpoint.createExchange();
                        exchange.getIn().setBody((Object)value);
                        KestrelConsumer.this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        if (exchange != null) {
                            KestrelConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
                            continue;
                        }
                        KestrelConsumer.this.getExceptionHandler().handleException((Throwable)e);
                    }
                }
                finally {
                    KestrelConsumer.this.pendingExchangeCount.decrementAndGet();
                }
            }
            KestrelConsumer.this.shutdownLatch.countDown();
            if (KestrelConsumer.this.log.isTraceEnabled()) {
                KestrelConsumer.this.log.trace("{} is finished", (Object)Thread.currentThread().getName());
            }
        }
    }

    private final class Poller
    implements Runnable {
        private boolean concurrent;

        private Poller(boolean concurrent) {
            this.concurrent = concurrent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            KestrelConsumer.this.log.trace("Kestrel poller is running");
            String target = KestrelConsumer.this.endpoint.getConfiguration().getWaitTimeMs() > 0 ? KestrelConsumer.this.endpoint.getQueue() + "/t=" + KestrelConsumer.this.endpoint.getConfiguration().getWaitTimeMs() : KestrelConsumer.this.endpoint.getQueue();
            Exchanger exchanger = null;
            while (KestrelConsumer.this.isRunAllowed() && !KestrelConsumer.this.shutdownPending) {
                if (this.concurrent) {
                    try {
                        exchanger = (Exchanger)KestrelConsumer.this.exchangerQueue.take();
                    }
                    catch (InterruptedException e) {
                        if (!KestrelConsumer.this.log.isDebugEnabled()) continue;
                        KestrelConsumer.this.log.debug("Interrupted, are we stopping? {}", (Object)(KestrelConsumer.this.isStopping() || KestrelConsumer.this.isStopped() ? 1 : 0));
                        continue;
                    }
                }
                Object value = null;
                while (KestrelConsumer.this.isRunAllowed() && !KestrelConsumer.this.shutdownPending) {
                    block19: {
                        KestrelConsumer.this.log.trace("Polling {}", (Object)target);
                        try {
                            value = KestrelConsumer.this.memcachedClient.get(target);
                            if (value != null) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            if (!KestrelConsumer.this.isRunAllowed() || KestrelConsumer.this.shutdownPending) break block19;
                            KestrelConsumer.this.getExceptionHandler().handleException("Failed to get object from kestrel", (Throwable)e);
                        }
                    }
                    if (!KestrelConsumer.this.isRunAllowed() || KestrelConsumer.this.shutdownPending || KestrelConsumer.this.endpoint.getConfiguration().getWaitTimeMs() > 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ignored) {}
                }
                KestrelConsumer.this.log.trace("Got object from {}", (Object)target);
                if (this.concurrent) {
                    try {
                        exchanger.exchange(value);
                    }
                    catch (InterruptedException e) {
                        if (!KestrelConsumer.this.log.isDebugEnabled()) continue;
                        KestrelConsumer.this.log.debug("Interrupted, are we stopping? {}", (Object)(KestrelConsumer.this.isStopping() || KestrelConsumer.this.isStopped() ? 1 : 0));
                    }
                    continue;
                }
                KestrelConsumer.this.pendingExchangeCount.incrementAndGet();
                try {
                    Exchange exchange = null;
                    try {
                        exchange = KestrelConsumer.this.endpoint.createExchange();
                        exchange.getIn().setBody(value);
                        KestrelConsumer.this.getProcessor().process(exchange);
                    }
                    catch (Exception e) {
                        if (exchange != null) {
                            KestrelConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
                            continue;
                        }
                        KestrelConsumer.this.getExceptionHandler().handleException((Throwable)e);
                    }
                }
                finally {
                    KestrelConsumer.this.pendingExchangeCount.decrementAndGet();
                }
            }
            KestrelConsumer.this.log.trace("Finished polling {}", (Object)target);
            KestrelConsumer.this.shutdownLatch.countDown();
        }
    }
}

