/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.rules;

import java.util.ArrayList;
import java.util.Date;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.bam.TimeExpression;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporalRule
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TemporalRule.class);
    private TimeExpression first;
    private TimeExpression second;
    private long expectedMillis;
    private long overdueMillis;
    private Processor overdueAction;
    private OutputDefinition<?> overdueProcessors = new OutputDefinition();

    public TemporalRule(TimeExpression first, TimeExpression second) {
        this.first = first;
        this.second = second;
    }

    public TemporalRule expectWithin(Time builder) {
        return this.expectWithin(builder.toMillis());
    }

    public TemporalRule expectWithin(long millis) {
        this.expectedMillis = millis;
        return this;
    }

    public OutputDefinition<?> errorIfOver(Time builder) {
        return this.errorIfOver(builder.toMillis());
    }

    public OutputDefinition<?> errorIfOver(long millis) {
        this.overdueMillis = millis;
        return this.overdueProcessors;
    }

    public TimeExpression getFirst() {
        return this.first;
    }

    public TimeExpression getSecond() {
        return this.second;
    }

    public Processor getOverdueAction() throws Exception {
        if (this.overdueAction == null && this.overdueProcessors != null) {
            RouteDefinition route = new RouteDefinition();
            DefaultRouteContext routeContext = new DefaultRouteContext((CamelContext)this.first.getBuilder().getProcessBuilder().getContext(), route, null, new ArrayList());
            this.overdueAction = this.overdueProcessors.createOutputsProcessor((RouteContext)routeContext);
        }
        return this.overdueAction;
    }

    public void processExchange(Exchange exchange, ProcessInstance instance) {
        Date overdue;
        Date expected;
        Date firstTime = this.first.evaluate(instance);
        if (firstTime == null) {
            return;
        }
        ActivityState secondState = this.second.getOrCreateActivityState(instance);
        if (this.expectedMillis > 0L && (expected = secondState.getTimeExpected()) == null) {
            expected = this.add(firstTime, this.expectedMillis);
            secondState.setTimeExpected(expected);
        }
        if (this.overdueMillis > 0L && (overdue = secondState.getTimeOverdue()) == null) {
            overdue = this.add(firstTime, this.overdueMillis);
            secondState.setTimeOverdue(overdue);
        }
    }

    public void processExpired(ActivityState activityState) throws Exception {
        Processor processor = this.getOverdueAction();
        if (processor != null) {
            Date now = new Date();
            ActivityState secondState = activityState;
            Date overdue = secondState.getTimeOverdue();
            if (now.compareTo(overdue) >= 0) {
                Exchange exchange = this.createExchange();
                exchange.getIn().setBody((Object)activityState);
                processor.process(exchange);
            } else {
                LOG.warn("Process has not actually expired; the time is: " + now + " but the overdue time is: " + overdue);
            }
        }
    }

    protected Exchange createExchange() {
        return new DefaultExchange((CamelContext)this.second.getBuilder().getProcessBuilder().getContext());
    }

    protected Date add(Date date, long millis) {
        return new Date(date.getTime() + millis);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices((Object[])new Object[]{this.getOverdueAction()});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices((Object[])new Object[]{this.getOverdueAction()});
    }
}

