/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.component;

import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.junit.Assert;
import org.junit.Test;

public class ApiMethodPropertiesHelperTest {
    private static final String TEST_PREFIX = "CamelTest.";
    private static final String PROPERTY_1 = "CamelTest.property1";
    private static final String PROPERTY_2 = "CamelTest.property2";
    private static final String PROPERTY_3 = "CamelTest.property3";
    private static final String PROPERTY_4 = "CamelTest.property4";
    private static final String PROPERTY_5 = "CamelTest.".substring(0, "CamelTest.".length() - 1) + "Property5";
    private static final String VALUE_1 = "value1";
    private static final long VALUE_2 = 2L;
    private static final String VALUE_3 = "value3";
    private static final String VALUE_4 = "true";
    private static final String VALUE_5 = "CamelCaseValue";
    private static ApiMethodPropertiesHelper<TestComponentConfiguration> propertiesHelper = new ApiMethodPropertiesHelper<TestComponentConfiguration>(TestComponentConfiguration.class, "CamelTest."){};

    @Test
    public void testGetExchangeProperties() throws Exception {
        HashMap properties = new HashMap();
        DefaultExchange exchange = new DefaultExchange((Endpoint)new MockEndpoint());
        exchange.getIn().setHeader(PROPERTY_1, (Object)VALUE_1);
        exchange.getIn().setHeader(PROPERTY_2, (Object)2L);
        exchange.getIn().setHeader(PROPERTY_3, (Object)VALUE_3);
        exchange.getIn().setHeader(PROPERTY_4, (Object)VALUE_4);
        exchange.getIn().setHeader(PROPERTY_5, (Object)VALUE_5);
        propertiesHelper.getExchangeProperties((Exchange)exchange, properties);
        Assert.assertEquals((long)5L, (long)properties.size());
    }

    @Test
    public void testGetEndpointProperties() throws Exception {
        HashMap properties = new HashMap();
        TestEndpointConfiguration endpointConfiguration = new TestEndpointConfiguration();
        endpointConfiguration.setProperty1(VALUE_1);
        endpointConfiguration.setProperty2(2L);
        endpointConfiguration.setProperty3(VALUE_3);
        endpointConfiguration.setProperty4(Boolean.valueOf(VALUE_4));
        propertiesHelper.getEndpointProperties((Object)endpointConfiguration, properties);
        Assert.assertEquals((long)2L, (long)properties.size());
    }

    @Test
    public void testGetEndpointPropertyNames() throws Exception {
        TestEndpointConfiguration endpointConfiguration = new TestEndpointConfiguration();
        endpointConfiguration.setProperty1(VALUE_1);
        endpointConfiguration.setProperty4(Boolean.valueOf(VALUE_4));
        Assert.assertEquals((long)1L, (long)propertiesHelper.getEndpointPropertyNames((Object)endpointConfiguration).size());
    }

    @Test
    public void testGetValidEndpointProperties() throws Exception {
        Assert.assertEquals((long)2L, (long)propertiesHelper.getValidEndpointProperties((Object)new TestEndpointConfiguration()).size());
    }

    private static class TestEndpointConfiguration
    extends TestComponentConfiguration {
        private String property3;
        private Boolean property4;

        private TestEndpointConfiguration() {
        }

        public String getProperty3() {
            return this.property3;
        }

        public void setProperty3(String property3) {
            this.property3 = property3;
        }

        public Boolean getProperty4() {
            return this.property4;
        }

        public void setProperty4(Boolean property4) {
            this.property4 = property4;
        }
    }

    private static class TestComponentConfiguration {
        private String property1;
        private Long property2;

        private TestComponentConfiguration() {
        }

        public String getProperty1() {
            return this.property1;
        }

        public void setProperty1(String property1) {
            this.property1 = property1;
        }

        public long getProperty2() {
            return this.property2;
        }

        public void setProperty2(Long property2) {
            this.property2 = property2;
        }
    }
}

