/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DumpModelAsXmlTransformRouteLanguageTest
extends ContextTestSupport {
    public void testDumpModelAsXml() throws Exception {
        String xml = ModelHelper.dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        DumpModelAsXmlTransformRouteLanguageTest.assertNotNull((Object)xml);
        this.log.info(xml);
        Document doc = new XmlConverter().toDOMDocument(xml);
        NodeList nodes = doc.getElementsByTagName("language");
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((int)1, (int)nodes.getLength());
        Element node = (Element)nodes.item(0);
        DumpModelAsXmlTransformRouteLanguageTest.assertNotNull((String)"Node <simple> expected to be instanceof Element", (Object)node);
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((String)"constant", (String)node.getAttribute("language"));
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((String)"Hello World", (String)node.getTextContent());
        nodes = doc.getElementsByTagName("to");
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((int)1, (int)nodes.getLength());
        node = (Element)nodes.item(0);
        DumpModelAsXmlTransformRouteLanguageTest.assertNotNull((String)"Node <to> expected to be instanceof Element", (Object)node);
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((String)"mock:result", (String)node.getAttribute("uri"));
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((String)"myMock", (String)node.getAttribute("id"));
        DumpModelAsXmlTransformRouteLanguageTest.assertEquals((String)"true", (String)node.getAttribute("customId"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("myRoute").transform((Expression)this.language("constant", "Hello World"))).to("mock:result")).id("myMock");
            }
        };
    }
}

