/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import junit.framework.TestCase;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionUseOriginalBodyTest
extends ContextTestSupport {
    public void testUseOriginalBody() throws Exception {
        MockEndpoint dead = this.getMockEndpoint("mock:a");
        dead.expectedBodiesReceived(new Object[]{"Hello"});
        this.template.sendBody("direct:a", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    public void testDoNotUseOriginalBody() throws Exception {
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        dead.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:b", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").disableRedelivery().logStackTrace(false).redeliveryDelay(0L));
                this.onException(IllegalArgumentException.class).maximumRedeliveries(2).useOriginalMessage().handled(true).to("mock:a");
                ((RouteDefinition)this.from("direct:a").setBody((Expression)this.body().append((Object)" World"))).process((Processor)new MyThrowProcessor(false));
                ((RouteDefinition)this.from("direct:b").setBody((Expression)this.body().append((Object)" World"))).process((Processor)new MyThrowProcessor(true));
            }
        };
    }

    public static class MyThrowProcessor
    implements Processor {
        private boolean camelException;

        public MyThrowProcessor() {
        }

        public MyThrowProcessor(boolean camelException) {
            this.camelException = camelException;
        }

        public void process(Exchange exchange) throws Exception {
            TestCase.assertEquals((String)"Hello World", (String)((String)exchange.getIn().getBody(String.class)));
            if (this.camelException) {
                throw new CamelExchangeException("I cannot do it", exchange);
            }
            throw new IllegalArgumentException("Forced");
        }

        public boolean isCamelException() {
            return this.camelException;
        }

        public void setCamelException(boolean camelException) {
            this.camelException = camelException;
        }
    }
}

