/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class InterceptSendToEndpointDynamicTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        InterceptSendToEndpointDynamicTest.deleteDirectory("target/foo");
        InterceptSendToEndpointDynamicTest.deleteDirectory("target/bar");
        InterceptSendToEndpointDynamicTest.deleteDirectory("target/cheese");
        super.setUp();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testSendToWildcard() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("file:*").skipSendToOriginalEndpoint().to("mock:detour");
                ((RouteDefinition)((RouteDefinition)this.from("direct:first").to("file://foo")).to("file://bar")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToWildcardHeaderUri() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("file:*").skipSendToOriginalEndpoint().to("mock:detour");
                ((RouteDefinition)this.from("direct:first").to("file://foo")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(1);
        this.getMockEndpoint("mock:detour").expectedHeaderReceived("CamelInterceptedEndpoint", (Object)"file://foo");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToRegex() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("file://target/(foo|bar)").skipSendToOriginalEndpoint().to("mock:detour");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:first").to("file://target/foo")).to("file://target/bar")).to("file://target/cheese")).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedMessageCount(2);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedFileExists("target/cheese/cheese.txt");
        this.template.sendBodyAndHeader("direct:first", (Object)"Hello World", "CamelFileName", (Object)"cheese.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToDynamicEndpoint() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("file:*").to("mock:detour");
                ((RouteDefinition)this.from("direct:first").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        InterceptSendToEndpointDynamicTest.this.template.sendBodyAndHeader("file://target/foo", (Object)"Hello Foo", "CamelFileName", (Object)"foo.txt");
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:detour").expectedBodiesReceived(new Object[]{"Hello Foo"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedFileExists("target/foo/foo.txt");
        this.template.sendBody("direct:first", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

