/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.dynamicrouter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.DynamicRouter;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;

public class DynamicRouterConcurrentPOJOTest
extends ContextTestSupport {
    private static final int COUNT = 100;

    public void testConcurrentDynamicRouter() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(100);
        this.getMockEndpoint("mock:b").expectedMessageCount(100);
        Thread sendToSedaA = this.createSedaSenderThread("seda:a");
        Thread sendToSedaB = this.createSedaSenderThread("seda:b");
        sendToSedaA.start();
        sendToSedaB.start();
        this.assertMockEndpointsSatisfied();
    }

    private Thread createSedaSenderThread(final String seda) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    DynamicRouterConcurrentPOJOTest.this.template.sendBody(seda, (Object)("Message from " + seda));
                }
            }
        });
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:a").bean((Object)new MyDynamicRouterPojo("mock:a"));
                this.from("seda:b").bean((Object)new MyDynamicRouterPojo("mock:b"));
            }
        };
    }

    public class MyDynamicRouterPojo {
        private final String target;

        public MyDynamicRouterPojo(String target) {
            this.target = target;
        }

        @DynamicRouter
        public String route(@Header(value="CamelSlipEndpoint") String previous) {
            if (previous == null) {
                return this.target;
            }
            return null;
        }
    }
}

