/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.processor.aggregator.AbstractDistributedTest;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;

public class DistributedOptimisticLockFailingTest
extends AbstractDistributedTest {
    private EverySecondOneFailsRepository sharedRepository = new EverySecondOneFailsRepository();

    public void testAlwaysFails() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        mock2.expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:fails", (Object)"hello world", "id", (Object)1);
            DistributedOptimisticLockFailingTest.fail((String)"Should throw CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(OptimisticLockingAggregationRepository.OptimisticLockingException.class, e.getCause().getCause());
        }
        try {
            this.template2.sendBodyAndHeader("direct:fails", (Object)"hello world", "id", (Object)1);
            DistributedOptimisticLockFailingTest.fail((String)"Should throw CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            DistributedOptimisticLockFailingTest.assertIsInstanceOf(OptimisticLockingAggregationRepository.OptimisticLockingException.class, e.getCause().getCause());
        }
        mock.assertIsSatisfied();
        mock2.assertIsSatisfied();
    }

    public void testEverySecondOneFails() throws Exception {
        int size = 200;
        ExecutorService service = Executors.newFixedThreadPool(50);
        ArrayList<1> tasks = new ArrayList<1>();
        int i = 0;
        while (i < size) {
            final int id = i % 25;
            final int choice = i % 2;
            final int count = i++;
            tasks.add(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (choice == 0) {
                        DistributedOptimisticLockFailingTest.this.template.sendBodyAndHeader("direct:everysecondone", (Object)("" + count), "id", (Object)id);
                    } else {
                        DistributedOptimisticLockFailingTest.this.template2.sendBodyAndHeader("direct:everysecondone", (Object)("" + count), "id", (Object)id);
                    }
                    return null;
                }
            });
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        MockEndpoint mock2 = this.getMockEndpoint2("mock:result");
        service.invokeAll(tasks);
        service.shutdown();
        service.awaitTermination(10L, TimeUnit.SECONDS);
        int contextCount = mock.getReceivedCounter();
        int context2Count = mock2.getReceivedCounter();
        DistributedOptimisticLockFailingTest.assertEquals((int)25, (int)(contextCount + context2Count));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:fails").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)new AlwaysFailingRepository()).optimisticLocking().optimisticLockRetryPolicy(new OptimisticLockRetryPolicy().maximumRetries(5)).completionSize(2).to("mock:result");
                this.from("direct:everysecondone").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)DistributedOptimisticLockFailingTest.this.sharedRepository).optimisticLocking().completionSize(8).to("mock:result");
            }
        };
    }

    private static final class EverySecondOneFailsRepository
    extends MemoryAggregationRepository {
        private AtomicInteger counter = new AtomicInteger();

        private EverySecondOneFailsRepository() {
            super(true);
        }

        public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
            int count = this.counter.incrementAndGet();
            if (count % 2 == 0) {
                throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
            }
            return super.add(camelContext, key, oldExchange, newExchange);
        }
    }

    private static final class AlwaysFailingRepository
    extends MemoryAggregationRepository {
        private AlwaysFailingRepository() {
        }

        public Exchange add(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
            throw new OptimisticLockingAggregationRepository.OptimisticLockingException();
        }
    }
}

