/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class AlbertoAggregatorTest
extends ContextTestSupport {
    private static final String SURNAME_HEADER = "surname";
    private static final String TYPE_HEADER = "type";
    private static final String BROTHERS_TYPE = "brothers";

    public void testAggregator() throws Exception {
        String allNames = "Harpo Marx,Fiodor Karamazov,Chico Marx,Ivan Karamazov,Groucho Marx,Alexei Karamazov,Dimitri Karamazov";
        ArrayList<String> marxBrothers = new ArrayList<String>();
        marxBrothers.add("Harpo");
        marxBrothers.add("Chico");
        marxBrothers.add("Groucho");
        ArrayList<String> karamazovBrothers = new ArrayList<String>();
        karamazovBrothers.add("Fiodor");
        karamazovBrothers.add("Ivan");
        karamazovBrothers.add("Alexei");
        karamazovBrothers.add("Dimitri");
        HashMap<String, ArrayList<String>> allBrothers = new HashMap<String, ArrayList<String>>();
        allBrothers.put("Marx", marxBrothers);
        allBrothers.put("Karamazov", karamazovBrothers);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(1);
        resultEndpoint.expectedBodiesReceived(new Object[]{allBrothers});
        this.template.sendBody("direct:start", (Object)allNames);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){
            AggregationStrategy surnameAggregator = new AggregationStrategy(){

                public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                    this.debugIn("Surname Aggregator", oldExchange, newExchange);
                    Exchange answer = newExchange;
                    if (oldExchange != null) {
                        List brothers = (List)oldExchange.getIn().getBody(List.class);
                        brothers.add(newExchange.getIn().getBody(String.class));
                        answer = oldExchange;
                    } else {
                        ArrayList<Object> brothers = new ArrayList<Object>();
                        brothers.add(newExchange.getIn().getBody(String.class));
                        newExchange.getIn().setBody(brothers);
                    }
                    this.debugOut("Surname Aggregator", answer);
                    return answer;
                }
            };
            AggregationStrategy brothersAggregator = new AggregationStrategy(){

                public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                    this.debugIn("Brothers Aggregator", oldExchange, newExchange);
                    Exchange answer = newExchange;
                    if (oldExchange != null) {
                        Map brothers = (Map)oldExchange.getIn().getBody(Map.class);
                        brothers.put(newExchange.getIn().getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), newExchange.getIn().getBody(List.class));
                        answer = oldExchange;
                    } else {
                        HashMap<Object, Object> brothers = new HashMap<Object, Object>();
                        brothers.put(newExchange.getIn().getHeader(AlbertoAggregatorTest.SURNAME_HEADER, String.class), newExchange.getIn().getBody(List.class));
                        newExchange.getIn().setBody(brothers);
                    }
                    this.debugOut("Brothers Aggregator", answer);
                    return answer;
                }
            };

            private void debugIn(String stringId, Exchange oldExchange, Exchange newExchange) {
                if (oldExchange != null) {
                    this.log.debug(stringId + " old headers in: " + oldExchange.getIn().getHeaders());
                    this.log.debug(stringId + " old body in: " + oldExchange.getIn().getBody());
                }
                this.log.debug(stringId + " new headers in: " + newExchange.getIn().getHeaders());
                this.log.debug(stringId + " new body in: " + newExchange.getIn().getBody());
            }

            private void debugOut(String stringId, Exchange exchange) {
                this.log.debug(stringId + " old headers out: " + exchange.getIn().getHeaders());
                this.log.debug(stringId + " old body out: " + exchange.getIn().getBody());
            }

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.bodyAs(String.class).tokenize(",")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String[] parts = ((String)exchange.getIn().getBody(String.class)).split(" ");
                        exchange.getIn().setBody((Object)parts[0]);
                        exchange.getIn().setHeader(AlbertoAggregatorTest.SURNAME_HEADER, (Object)parts[1]);
                    }
                })).to("direct:joinSurnames");
                ((AggregateDefinition)this.from("direct:joinSurnames").aggregate((Expression)this.header(AlbertoAggregatorTest.SURNAME_HEADER), this.surnameAggregator).completionTimeout(2000L).setHeader(AlbertoAggregatorTest.TYPE_HEADER, (Expression)this.constant(AlbertoAggregatorTest.BROTHERS_TYPE))).to("direct:joinBrothers");
                AggregateDefinition agg = this.from("direct:joinBrothers").aggregate((Expression)this.header(AlbertoAggregatorTest.TYPE_HEADER), this.brothersAggregator);
                agg.setCompletionTimeout(Long.valueOf(2000L));
                ((AggregateDefinition)((AggregateDefinition)agg.removeHeader(AlbertoAggregatorTest.SURNAME_HEADER)).removeHeader(AlbertoAggregatorTest.TYPE_HEADER)).to("mock:result");
            }
        };
    }
}

