/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class AggregatorExceptionHandleTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    public void testHandled() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:handled");
        mock.expectedBodiesReceived(new Object[]{"Damn"});
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "id", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Damn", "id", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:handled");
                ((AggregateDefinition)this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new UseLatestAggregationStrategy()).completionTimeout(1000L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Damn".equals(body)) {
                            throw new IllegalArgumentException("Damn");
                        }
                        exchange.getOut().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

