/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.DefaultAggregateController;
import org.junit.Test;

public class AggregateControllerTest
extends ContextTestSupport {
    private AggregateController controller;

    public AggregateController getAggregateController() {
        if (this.controller == null) {
            this.controller = new DefaultAggregateController();
        }
        return this.controller;
    }

    @Test
    public void testForceCompletionOfAll() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(2);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3", "test2test4"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        int groups = this.getAggregateController().forceCompletionOfAllGroups();
        AggregateControllerTest.assertEquals((int)2, (int)groups);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testForceCompletionOfGroup() throws Exception {
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(0);
        this.template.sendBodyAndHeader("direct:start", (Object)"test1", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test2", "id", (Object)"2");
        this.template.sendBodyAndHeader("direct:start", (Object)"test3", "id", (Object)"1");
        this.template.sendBodyAndHeader("direct:start", (Object)"test4", "id", (Object)"2");
        this.assertMockEndpointsSatisfied();
        this.getMockEndpoint("mock:aggregated").expectedMessageCount(1);
        this.getMockEndpoint("mock:aggregated").expectedBodiesReceivedInAnyOrder(new Object[]{"test1test3"});
        this.getMockEndpoint("mock:aggregated").expectedPropertyReceived("CamelAggregatedCompletedBy", (Object)"force");
        int groups = this.getAggregateController().forceCompletionOfGroup("1");
        AggregateControllerTest.assertEquals((int)1, (int)groups);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").aggregate((Expression)this.header("id"), (AggregationStrategy)new MyAggregationStrategy()).aggregateController(AggregateControllerTest.this.getAggregateController()).completionSize(10).to("mock:aggregated");
            }
        };
    }

    public static class MyAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            String body1 = (String)oldExchange.getIn().getBody(String.class);
            String body2 = (String)newExchange.getIn().getBody(String.class);
            oldExchange.getIn().setBody((Object)(body1 + body2));
            return oldExchange;
        }
    }
}

