/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregator;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.spi.AggregationRepository;

public class AggregateCompleteAllOnStopTest
extends ContextTestSupport {
    public void testCompleteAllOnStop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:aggregated");
        mock.expectedBodiesReceived(new Object[]{"A+B", "C"});
        this.template.sendBodyAndHeader("seda:start", (Object)"A", "id", (Object)"foo");
        this.template.sendBodyAndHeader("seda:start", (Object)"B", "id", (Object)"foo");
        this.template.sendBodyAndHeader("seda:start", (Object)"C", "id", (Object)"foo");
        this.context.stopRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:start").routeId("foo").aggregate((Expression)this.header("id"), (AggregationStrategy)new BodyInAggregatingStrategy()).aggregationRepository((AggregationRepository)new MemoryAggregationRepository()).completionSize(2).completionTimeout(2000L).completeAllOnStop().to("mock:aggregated");
            }
        };
    }
}

