/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ThreadsDefinition;

public class ThreadsCorePoolTest
extends ContextTestSupport {
    private String beforeThreadName;
    private volatile String afterThreadName;

    public void testThreadsCorePool() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        ThreadsCorePoolTest.assertNotNull((String)"The main thread name should be already properly set!", (Object)this.beforeThreadName);
        ThreadsCorePoolTest.assertNotNull((String)"The camel thread name should be already properly set!", (Object)this.afterThreadName);
        ThreadsCorePoolTest.assertFalse((String)"Should use different threads", (boolean)this.beforeThreadName.equalsIgnoreCase(this.afterThreadName));
    }

    public void testThreadsCorePoolBuilder() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        ThreadsCorePoolTest.assertNotNull((String)"The main thread name should be already properly set!", (Object)this.beforeThreadName);
        ThreadsCorePoolTest.assertNotNull((String)"The camel thread name should be already properly set!", (Object)this.afterThreadName);
        ThreadsCorePoolTest.assertFalse((String)"Should use different threads", (boolean)this.beforeThreadName.equalsIgnoreCase(this.afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ThreadsCorePoolTest.this.context.setTracing(Boolean.valueOf(true));
                ((ThreadsDefinition)((ThreadsDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ThreadsCorePoolTest.this.beforeThreadName = Thread.currentThread().getName();
                    }
                })).threads(5).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ThreadsCorePoolTest.this.afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:result");
                ((ThreadsDefinition)((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ThreadsCorePoolTest.this.beforeThreadName = Thread.currentThread().getName();
                    }
                })).threads().poolSize(5).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ThreadsCorePoolTest.this.afterThreadName = Thread.currentThread().getName();
                    }
                })).to("mock:result");
            }
        };
    }
}

