/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class StreamCachingOnlyRouteTest
extends ContextTestSupport {
    public void testStreamCachingPerRoute() throws Exception {
        MockEndpoint c = this.getMockEndpoint("mock:c");
        c.expectedMessageCount(1);
        new StreamSource(new StringReader("A"));
        this.template.sendBody("direct:c", (Object)new StreamSource(new StringReader("C")));
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().getProperties().put("CamelCachedOutputStreamThreshold", "4096");
                this.from("direct:c").streamCaching().to("mock:c");
            }
        };
    }
}

