/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;

public class SplitterParallelStopOnExceptionTest
extends ContextTestSupport {
    private ExecutorService service;

    @Override
    protected void setUp() throws Exception {
        this.service = Executors.newFixedThreadPool(2);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.service.shutdownNow();
    }

    public void testSplitParallelStopOnExceptionOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World,Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSplitParallelStopOnExceptionStop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMinimumMessageCount(0);
        ((ValueBuilder)mock.allMessages().body()).isNotEqualTo((Object)"Kaboom");
        try {
            this.template.sendBody("direct:start", (Object)"Hello World,Goodday World,Kaboom,Bye World");
            SplitterParallelStopOnExceptionTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelExchangeException cause = SplitterParallelStopOnExceptionTest.assertIsInstanceOf(CamelExchangeException.class, e.getCause());
            SplitterParallelStopOnExceptionTest.assertTrue((boolean)cause.getMessage().startsWith("Parallel processing failed for number "));
            SplitterParallelStopOnExceptionTest.assertTrue((boolean)cause.getMessage().contains("[Message: Kaboom]"));
            SplitterParallelStopOnExceptionTest.assertEquals((String)"Forced", (String)cause.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize(",")).parallelProcessing().stopOnException().executorService(SplitterParallelStopOnExceptionTest.this.service).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:split");
            }
        };
    }
}

