/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class ShutdownCompleteAllTasksTest
extends ContextTestSupport {
    private static String url = "file:target/pending";
    private static AtomicInteger counter = new AtomicInteger();

    @Override
    protected void setUp() throws Exception {
        ShutdownCompleteAllTasksTest.deleteDirectory("target/pending");
        super.setUp();
        this.template.sendBodyAndHeader(url, (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(url, (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(url, (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(url, (Object)"D", "CamelFileName", (Object)"d.txt");
        this.template.sendBodyAndHeader(url, (Object)"E", "CamelFileName", (Object)"e.txt");
    }

    public void testShutdownCompleteAllTasks() throws Exception {
        this.context.getShutdownStrategy().setTimeout(30L);
        this.context.startRoute("foo");
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        bar.await(20L, TimeUnit.SECONDS);
        int batch = (Integer)((Exchange)bar.getReceivedExchanges().get(0)).getProperty("CamelBatchSize", Integer.TYPE);
        this.context.stop();
        ShutdownCompleteAllTasksTest.assertEquals((String)"Should complete all messages", (int)batch, (int)counter.get());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from(url).routeId("foo").noAutoStartup().shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).process((Processor)new MyProcessor())).to("mock:bar");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Thread.sleep(500L);
            counter.incrementAndGet();
        }
    }
}

