/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.TransactedDefinition;

public class RouteTopLevelMisconfiguredTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testInvalidOnException() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((OnExceptionDefinition)this.from("direct:start").split((Expression)this.body()).onException(IllegalArgumentException.class).to("mock:illegal")).end().to("mock:split").end();
                }
            });
            RouteTopLevelMisconfiguredTest.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            RouteTopLevelMisconfiguredTest.assertTrue((boolean)e.getMessage().startsWith("The output must be added as top-level on the route."));
        }
    }

    public void testInvalidOnCompletion() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((OnCompletionDefinition)this.from("direct:start").split((Expression)this.body()).onCompletion().to("mock:done")).end().to("mock:split").end();
                }
            });
            RouteTopLevelMisconfiguredTest.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            RouteTopLevelMisconfiguredTest.assertTrue((boolean)e.getMessage().startsWith("The output must be added as top-level on the route."));
        }
    }

    public void testInvalidTransacted() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    ((TransactedDefinition)this.from("direct:start").split((Expression)this.body()).transacted().to("mock:split")).end();
                }
            });
            RouteTopLevelMisconfiguredTest.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            RouteTopLevelMisconfiguredTest.assertTrue((boolean)e.getMessage().startsWith("The output must be added as top-level on the route."));
        }
    }
}

