/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RouteStartupOrder;

public class RouteStartupOrderWithDefaultTest
extends ContextTestSupport {
    public void testRouteStartupOrder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getRouteStartupOrder();
        RouteStartupOrderWithDefaultTest.assertEquals((int)5, (int)order.size());
        RouteStartupOrderWithDefaultTest.assertEquals((String)"seda://foo", (String)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderWithDefaultTest.assertEquals((String)"direct://start", (String)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderWithDefaultTest.assertEquals((String)"seda://bar", (String)((RouteStartupOrder)order.get(2)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderWithDefaultTest.assertEquals((String)"direct://bar", (String)((RouteStartupOrder)order.get(3)).getRoute().getEndpoint().getEndpointUri());
        RouteStartupOrderWithDefaultTest.assertEquals((String)"direct://default", (String)((RouteStartupOrder)order.get(4)).getRoute().getEndpoint().getEndpointUri());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").startupOrder(2).to("seda:foo");
                this.from("seda:foo").startupOrder(1).to("mock:result");
                this.from("direct:bar").startupOrder(9).to("seda:bar");
                this.from("seda:bar").startupOrder(5).to("mock:other");
                this.from("direct:default").to("mock:default");
            }
        };
    }
}

