/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class RouteNoAutoStartupTest
extends ContextTestSupport {
    public void testRouteNotAutoStarted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        Thread.sleep(100L);
        this.assertMockEndpointsSatisfied();
    }

    public void testRouteNotAutoStartedThenStarted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        Thread.sleep(100L);
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        this.context.startRoute("myRoute");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").noAutoStartup().id("myRoute")).to("mock:result");
            }
        };
    }
}

