/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RouteIdTest
extends ContextTestSupport {
    public void testRouteId() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = ((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId();
        RouteIdTest.assertEquals((String)"myCoolRoute", (String)id);
    }

    public void testRouteIdFailed() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Kabom");
        this.assertMockEndpointsSatisfied();
        String id = ((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId();
        RouteIdTest.assertEquals((String)"myCoolRoute", (String)id);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).to("mock:error")).end();
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").onException(IOException.class).maximumRedeliveries(5).end().routeId("myCoolRoute").choice().when(this.body().contains((Object)"Kabom")).throwException((Exception)new IllegalArgumentException("Damn"))).otherwise().to("mock:result")).end();
            }
        };
    }
}

