/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class RouteContextProcessorTest
extends ContextTestSupport {
    public static final int CONCURRENCY = 10;
    public static final long SAFETY_TIMEOUT = 100L;
    public static final int SAFETY_CAPACITY = 10;
    public static final long TIMEOUT = 145L;
    public static final int CAPACITY = 300;
    private static final int NUMBER_OF_MESSAGES = 10000;

    public void testForkAndJoin() throws InterruptedException {
    }

    public void xxxTestForkAndJoin() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(10000);
        ProducerTemplate template = this.context.createProducerTemplate();
        for (int i = 0; i < 10000; ++i) {
            template.sendBodyAndHeader("seda:fork", (Object)("Test Message: " + i), "seqnum", (Object)new Long(i));
        }
        long expectedTime = 27645L;
        Thread.sleep(expectedTime);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                RandomSleepProcessor myProcessor = new RandomSleepProcessor();
                ((RouteDefinition)this.from("seda:fork?concurrentConsumers=10").process((Processor)myProcessor)).to("seda:join");
                this.from("seda:join").resequence((Expression)this.header("seqnum")).stream().capacity(300).timeout(145L).to("mock:result");
            }
        };
    }

    public static class RandomSleepProcessor
    implements Processor {
        public static final long MIN_PROCESS_TIME = 5L;
        public static final long MAX_PROCESS_TIME = 50L;

        public void process(Exchange arg0) throws Exception {
            long processTime = (long)(5.0 + Math.random() * 45.0);
            Thread.sleep(processTime);
        }
    }
}

