/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class RollbackDefaultErrorHandlerTest
extends ContextTestSupport {
    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.requestBody("direct:start", (Object)"ok");
        this.assertMockEndpointsSatisfied();
    }

    public void testRollback() throws Exception {
        try {
            this.template.requestBody("direct:start", (Object)"bad");
            RollbackDefaultErrorHandlerTest.fail((String)"Should have thrown a RollbackExchangeException");
        }
        catch (RuntimeCamelException e) {
            RollbackDefaultErrorHandlerTest.assertTrue((boolean)(e.getCause() instanceof RollbackExchangeException));
        }
    }

    public void testRollbackWithExchange() throws Exception {
        Exchange out = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"bad");
            }
        });
        RollbackDefaultErrorHandlerTest.assertNotNull((Object)out.getException());
        RollbackDefaultErrorHandlerTest.assertIsInstanceOf(RollbackExchangeException.class, out.getException());
        RollbackDefaultErrorHandlerTest.assertEquals((String)"Should be marked as rollback", (boolean)true, (boolean)out.isRollbackOnly());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().isNotEqualTo((Object)"ok")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertFalse((String)"Rollback flag should have been cleared on redelivery", (boolean)exchange.isRollbackOnly());
                    }
                })).to("mock:rollback")).rollback("That do not work")).otherwise().to("mock:result")).end();
            }
        };
    }
}

