/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class RemovePropertiesWithExclusionTest
extends ContextTestSupport {
    private MockEndpoint end;
    private MockEndpoint mid;
    private String propertyName = "foo";
    private String expectedPropertyValue = "bar";
    private String propertyName1 = "fee";
    private String expectedPropertyValue1 = "bar1";
    private String propertyName2 = "fiu";
    private String expectedPropertyValue2 = "bar2";
    private String pattern = "f*";
    private String exclusion = "fiu";

    public void testSetExchangePropertiesMidRouteThenRemoveWithPatternAndExclusion() throws Exception {
        this.mid.expectedMessageCount(1);
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"message");
        this.assertMockEndpointsSatisfied();
        List midExchanges = this.mid.getExchanges();
        Exchange midExchange = (Exchange)midExchanges.get(0);
        String actualPropertyValue = (String)midExchange.getProperty(this.propertyName, String.class);
        String actualPropertyValue1 = (String)midExchange.getProperty(this.propertyName1, String.class);
        String actualPropertyValue2 = (String)midExchange.getProperty(this.propertyName2, String.class);
        RemovePropertiesWithExclusionTest.assertEquals((String)this.expectedPropertyValue, (String)actualPropertyValue);
        RemovePropertiesWithExclusionTest.assertEquals((String)this.expectedPropertyValue1, (String)actualPropertyValue1);
        RemovePropertiesWithExclusionTest.assertEquals((String)this.expectedPropertyValue2, (String)actualPropertyValue2);
        List endExchanges = this.end.getExchanges();
        Exchange endExchange = (Exchange)endExchanges.get(0);
        RemovePropertiesWithExclusionTest.assertNull((Object)endExchange.getProperty(this.propertyName, String.class));
        RemovePropertiesWithExclusionTest.assertNull((Object)endExchange.getProperty(this.propertyName1, String.class));
        RemovePropertiesWithExclusionTest.assertEquals((String)this.expectedPropertyValue2, (String)((String)endExchange.getProperty(this.propertyName2, String.class)));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
        this.mid = this.getMockEndpoint("mock:mid");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:start").setProperty(RemovePropertiesWithExclusionTest.this.propertyName).constant((Object)RemovePropertiesWithExclusionTest.this.expectedPropertyValue)).setProperty(RemovePropertiesWithExclusionTest.this.propertyName1).constant((Object)RemovePropertiesWithExclusionTest.this.expectedPropertyValue1)).setProperty(RemovePropertiesWithExclusionTest.this.propertyName2).constant((Object)RemovePropertiesWithExclusionTest.this.expectedPropertyValue2)).to("mock:mid")).removeProperties(RemovePropertiesWithExclusionTest.this.pattern, new String[]{RemovePropertiesWithExclusionTest.this.exclusion})).to("mock:end");
            }
        };
    }
}

