/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryOnExceptionBlockedDelayTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryOnExceptionBlockedDelayTest.class);
    private static volatile int attempt;

    public void testRedelivery() throws Exception {
        MockEndpoint before = this.getMockEndpoint("mock:result");
        before.expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello World", "Hello Camel"});
        this.template.sendBody("seda:start", (Object)"World");
        this.template.sendBody("seda:start", (Object)"Camel");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(5).redeliveryDelay(2000L);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start").to("log:before")).to("mock:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        LOG.info("Processing at attempt " + attempt + " " + exchange);
                        String body = (String)exchange.getIn().getBody(String.class);
                        if (body.contains("World") && ++attempt <= 2) {
                            LOG.info("Processing failed will thrown an exception");
                            throw new IllegalArgumentException("Damn");
                        }
                        exchange.getIn().setBody((Object)("Hello " + body));
                        LOG.info("Processing at attempt " + attempt + " complete " + exchange);
                    }
                })).to("log:after")).to("mock:result");
            }
        };
    }
}

