/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;

public class RedeliveryErrorHandlerLogHandledTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testRedeliveryErrorHandlerOnExceptionLogHandledDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).handled(true).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRedeliveryErrorHandlerOnExceptionLogHandled() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).logHandled(true).handled(true).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRedeliveryErrorHandlerOnExceptionLogRetryAttempted() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).logHandled(true).logRetryAttempted(true).handled(true).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testRedeliveryErrorHandlerDoNotLogExhausted() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().logExhausted(false));
                this.from("direct:bar").throwException((Exception)new CamelException("Camel rocks"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:bar", (Object)"Hello World");
            RedeliveryErrorHandlerLogHandledTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelException cause = RedeliveryErrorHandlerLogHandledTest.assertIsInstanceOf(CamelException.class, e.getCause());
            RedeliveryErrorHandlerLogHandledTest.assertEquals((String)"Camel rocks", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testRedeliveryErrorHandlerLogExhaustedDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler());
                this.from("direct:bar").throwException((Exception)new CamelException("Camel rocks"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:bar", (Object)"Hello World");
            RedeliveryErrorHandlerLogHandledTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelException cause = RedeliveryErrorHandlerLogHandledTest.assertIsInstanceOf(CamelException.class, e.getCause());
            RedeliveryErrorHandlerLogHandledTest.assertEquals((String)"Camel rocks", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testRedeliveryErrorHandlerAllOptions() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(3).logExhausted(true).logHandled(true).logRetryStackTrace(true).logStackTrace(true).retryAttemptedLogLevel(LoggingLevel.WARN).retriesExhaustedLogLevel(LoggingLevel.ERROR));
                this.from("direct:bar").throwException((Exception)new CamelException("Camel rocks"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:bar", (Object)"Hello World");
            RedeliveryErrorHandlerLogHandledTest.fail((String)"Should thrown an exception");
        }
        catch (CamelExecutionException e) {
            CamelException cause = RedeliveryErrorHandlerLogHandledTest.assertIsInstanceOf(CamelException.class, e.getCause());
            RedeliveryErrorHandlerLogHandledTest.assertEquals((String)"Camel rocks", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testRedeliveryErrorHandlerOnExceptionAllOptions() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).maximumRedeliveries(3).logHandled(true).logRetryAttempted(true).logRetryStackTrace(true).logExhausted(true).logStackTrace(true).handled(true).retryAttemptedLogLevel(LoggingLevel.WARN).retriesExhaustedLogLevel(LoggingLevel.ERROR).to("mock:handled");
                this.from("direct:foo").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:handled").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

