/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;

public class MulticastUnitOfWorkTest
extends ContextTestSupport {
    private static String sync;
    private static String lastOne;

    public void testMulticastUOW() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MulticastUnitOfWorkTest.assertEquals((String)"onCompleteA", (String)sync);
        MulticastUnitOfWorkTest.assertEquals((String)"onCompleteA", (String)lastOne);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                MulticastUnitOfWorkTest.this.context.setTracing(Boolean.valueOf(true));
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyUOWProcessor("A"))).multicast().to(new String[]{"direct:foo", "direct:bar"});
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:foo").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertNull((String)"First exchange is not complete yet", (Object)sync);
                    }
                })).process((Processor)new MyUOWProcessor("B"))).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        lastOne = "processor";
                    }
                })).to("mock:result");
                this.from("direct:bar").to("mock:result");
            }
        };
    }

    private static final class MyUOWProcessor
    implements Processor {
        private String id;

        private MyUOWProcessor(String id) {
            this.id = id;
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getUnitOfWork().addSynchronization(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    sync = "onComplete" + MyUOWProcessor.this.id;
                    lastOne = sync;
                }

                public void onFailure(Exchange exchange) {
                    sync = "onFailure" + MyUOWProcessor.this.id;
                    lastOne = sync;
                }
            });
        }
    }
}

