/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class MulticastParallelTimeout3Test
extends ContextTestSupport {
    public void testMulticastParallelTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((ValueBuilder)mock.message(0).body()).not(MulticastParallelTimeout3Test.body().contains((Object)"C"));
        this.getMockEndpoint("mock:A").expectedMessageCount(1);
        this.getMockEndpoint("mock:B").expectedMessageCount(1);
        this.getMockEndpoint("mock:C").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:start").multicast(new AggregationStrategy(){

                    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
                        if (oldExchange == null) {
                            return newExchange;
                        }
                        String body = (String)oldExchange.getIn().getBody(String.class);
                        oldExchange.getIn().setBody((Object)(body + (String)newExchange.getIn().getBody(String.class)));
                        return oldExchange;
                    }
                }).parallelProcessing().timeout(250L).to(new String[]{"direct:a", "direct:b", "direct:c"})).end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").to("mock:A")).setBody((Expression)this.constant("A"));
                ((RouteDefinition)this.from("direct:b").to("mock:B")).setBody((Expression)this.constant("B"));
                ((ExpressionNode)this.from("direct:c").delay(1000L).to("mock:C")).setBody((Expression)this.constant("C"));
            }
        };
    }
}

