/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class LoopWithAggregatorTest
extends ContextTestSupport {
    public void testLoopCopy() throws Exception {
        this.getMockEndpoint("mock:loop").expectedBodiesReceived(new Object[]{"AB", "AB", "AB"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"AB"});
        this.template.requestBody("direct:start", (Object)"A");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((ExpressionNode)this.from("direct:start").loop(3).copy().enrich("direct:getTimeStamp", (AggregationStrategy)new ExampleAggregationStrategy())).inOnly("mock:loop")).end().to("mock:result");
                this.from("direct:getTimeStamp").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody((Object)"B");
                    }
                });
            }
        };
    }

    public static class ExampleAggregationStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange original, Exchange resource) {
            String originalBody = (String)original.getIn().getBody(String.class);
            if (original.getOut().getBody() != null) {
                originalBody = (String)original.getOut().getBody(String.class);
            }
            String resourceResponse = (String)resource.getIn().getBody(String.class);
            String mergeResult = originalBody + resourceResponse;
            if (original.getPattern().isOutCapable()) {
                original.getOut().setBody((Object)mergeResult);
            } else {
                original.getIn().setBody((Object)mergeResult);
            }
            return original;
        }
    }
}

