/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;

public class FileIdempotentTrunkStoreTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private File store = new File("target/idempotentfilestore.dat");
    private IdempotentRepository<String> repo;

    public void testTrunkFileStore() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"A", "B", "C", "D", "E"});
        this.sendMessage("AAAAAAAAAA", "A");
        this.sendMessage("BBBBBBBBBB", "B");
        this.sendMessage("CCCCCCCCCC", "C");
        this.sendMessage("AAAAAAAAAA", "A");
        this.sendMessage("DDDDDDDDDD", "D");
        this.sendMessage("BBBBBBBBBB", "B");
        this.sendMessage("EEEEEEEEEE", "E");
        this.resultEndpoint.assertIsSatisfied();
        this.resultEndpoint.reset();
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Z", "X"});
        this.sendMessage("ZZZZZZZZZZ", "Z");
        IdempotentRepository repo2 = FileIdempotentRepository.fileIdempotentRepository((File)this.store);
        repo2.start();
        FileIdempotentTrunkStoreTest.assertFalse((boolean)repo2.contains((Object)"AAAAAAAAAA"));
        FileIdempotentTrunkStoreTest.assertTrue((boolean)repo2.contains((Object)"BBBBBBBBBB"));
        FileIdempotentTrunkStoreTest.assertTrue((boolean)repo2.contains((Object)"CCCCCCCCCC"));
        FileIdempotentTrunkStoreTest.assertTrue((boolean)repo2.contains((Object)"DDDDDDDDDD"));
        FileIdempotentTrunkStoreTest.assertTrue((boolean)repo2.contains((Object)"EEEEEEEEEE"));
        FileIdempotentTrunkStoreTest.assertTrue((boolean)repo2.contains((Object)"ZZZZZZZZZZ"));
        this.sendMessage("XXXXXXXXXX", "X");
        this.resultEndpoint.assertIsSatisfied();
        FileIdempotentTrunkStoreTest.assertFalse((boolean)this.repo.contains((Object)"BBBBBBBBBB"));
        FileIdempotentTrunkStoreTest.assertTrue((boolean)this.repo.contains((Object)"XXXXXXXXXX"));
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        if (this.store.exists()) {
            this.store.delete();
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)this.store, (int)5, (long)50L);
        this.repo.start();
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), FileIdempotentTrunkStoreTest.this.repo).to("mock:result");
            }
        };
    }
}

