/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class ErrorHandlerWrappedEachNodeTest
extends ContextTestSupport {
    private static int kabom;
    private static int hi;

    public void testKabom() throws Exception {
        kabom = 0;
        hi = 0;
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hi Kabom"});
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Kabom");
        this.assertMockEndpointsSatisfied();
        ErrorHandlerWrappedEachNodeTest.assertEquals((int)3, (int)kabom);
        ErrorHandlerWrappedEachNodeTest.assertEquals((int)1, (int)hi);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(3).redeliveryDelay(0L).logStackTrace(false));
                ((RouteDefinition)this.from("direct:start").pipeline(new String[]{"bean:foo?method=hi", "bean:foo?method=kabom"})).to("mock:result");
            }
        };
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyFooBean());
        return jndi;
    }

    public static final class MyFooBean {
        public void kabom() throws Exception {
            if (kabom++ < 2) {
                throw new IllegalArgumentException("Kabom");
            }
        }

        public String hi(String payload) throws Exception {
            hi++;
            return "Hi " + payload;
        }
    }
}

