/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Channel;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.EventDrivenConsumerRoute;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.DefaultErrorHandler;
import org.apache.camel.processor.Pipeline;

public class DefaultErrorHandlerTest
extends ContextTestSupport {
    public void testRoute() {
        Route route = (Route)this.context.getRoutes().get(0);
        EventDrivenConsumerRoute consumerRoute = DefaultErrorHandlerTest.assertIsInstanceOf(EventDrivenConsumerRoute.class, route);
        Processor processor = DefaultErrorHandlerTest.unwrap(consumerRoute.getProcessor());
        Pipeline pipeline = DefaultErrorHandlerTest.assertIsInstanceOf(Pipeline.class, processor);
        for (Processor child : pipeline.getProcessors()) {
            Channel channel = DefaultErrorHandlerTest.assertIsInstanceOf(Channel.class, child);
            DefaultErrorHandlerTest.assertNotNull((String)"There should be an error handler", (Object)channel.getErrorHandler());
            DefaultErrorHandlerTest.assertIsInstanceOf(DefaultErrorHandler.class, channel.getErrorHandler());
        }
    }

    public void testOk() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testWithError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Kabom");
            DefaultErrorHandlerTest.fail((String)"Should have thrown a RuntimeCamelException");
        }
        catch (RuntimeCamelException runtimeCamelException) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kabom".equals(body)) {
                            throw new IllegalArgumentException("Boom");
                        }
                        exchange.getIn().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

