/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ProcessorBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelExceptionCausePropagatedTest
extends ContextTestSupport {
    protected static final RuntimeException RUNTIME_EXCEPTION = new RuntimeException("Expected exception.");
    protected String body = "<hello>world!</hello>";

    public void testFirstFewAttemptsFail() throws Exception {
        MockEndpoint failedEndpoint = this.getMockEndpoint("mock:failed");
        MockEndpoint successEndpoint = this.getMockEndpoint("mock:success");
        failedEndpoint.expectedBodiesReceived(new Object[]{this.body});
        ((ValueBuilder)failedEndpoint.message(0).exchangeProperty("CamelExceptionCaught")).isEqualTo((Object)RUNTIME_EXCEPTION);
        failedEndpoint.expectedMessageCount(1);
        successEndpoint.expectedMessageCount(0);
        this.sendBody("direct:start", this.body);
        this.assertMockEndpointsSatisfied();
        DeadLetterChannelExceptionCausePropagatedTest.assertNull((Object)((Exchange)failedEndpoint.getExchanges().get(0)).getException());
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                this.onException(RuntimeException.class).handled(true).to("mock:failed");
                ((RouteDefinition)this.from("direct:start").process(ProcessorBuilder.throwException((Exception)RUNTIME_EXCEPTION))).to("mock:success");
            }
        };
    }
}

