/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class ChoiceWhenBeanExpressionTest
extends ContextTestSupport {
    private MockEndpoint gradeA;
    private MockEndpoint otherGrade;

    protected void verifyGradeA(String endpointUri) throws Exception {
        this.gradeA.reset();
        this.otherGrade.reset();
        this.gradeA.expectedMessageCount(1);
        this.otherGrade.expectedMessageCount(0);
        this.template.sendBody(endpointUri, (Object)new Student(95));
        this.assertMockEndpointsSatisfied();
    }

    public void verifyOtherGrade(String endpointUri) throws Exception {
        this.gradeA.reset();
        this.otherGrade.reset();
        this.gradeA.expectedMessageCount(0);
        this.otherGrade.expectedMessageCount(1);
        this.template.sendBody(endpointUri, (Object)new Student(60));
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanExpression() throws Exception {
        this.verifyGradeA("direct:expression");
        this.verifyOtherGrade("direct:expression");
    }

    public void testMethod() throws Exception {
        this.verifyGradeA("direct:method");
        this.verifyOtherGrade("direct:method");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.gradeA = this.getMockEndpoint("mock:gradeA");
        this.otherGrade = this.getMockEndpoint("mock:otherGrade");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:expression").choice().when().expression((Expression)this.method(MyBean.class, "isGradeA"))).to("mock:gradeA")).otherwise().to("mock:otherGrade")).end();
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:method").choice().when().method(MyBean.class)).to("mock:gradeA")).otherwise().to("mock:otherGrade")).end();
            }
        };
    }

    class Student {
        private int grade;

        public Student(int grade) {
            this.grade = grade;
        }

        public int getGrade() {
            return this.grade;
        }
    }

    public static class MyBean {
        public boolean isGradeA(@Body Student student) {
            return student.getGrade() >= 90;
        }
    }
}

