/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import junit.framework.TestCase;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSanityCheckerTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ModelSanityCheckerTest.class);

    private Set<Class<?>> discoverJaxbClasses() {
        DefaultPackageScanClassResolver resolver = new DefaultPackageScanClassResolver();
        String[] packages = "org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.model.rest".split(":");
        return resolver.findAnnotated(XmlAccessorType.class, packages);
    }

    public void testSanity() throws Exception {
        Set<Class<?>> classes = this.discoverJaxbClasses();
        ModelSanityCheckerTest.assertNotNull(classes);
        ModelSanityCheckerTest.assertTrue((String)("There should be > 140 classes, was: " + classes.size()), (classes.size() > 140 ? 1 : 0) != 0);
        for (Class<?> clazz : classes) {
            boolean elementRef;
            boolean element;
            boolean attribute;
            if (clazz == ProcessorDefinition.class || clazz == RouteDefinition.class) continue;
            for (Field field : clazz.getDeclaredFields()) {
                LOG.debug("Class {} has field {}", (Object)clazz.getName(), (Object)field.getName());
                attribute = field.getAnnotation(XmlAttribute.class) != null;
                element = field.getAnnotation(XmlElement.class) != null;
                boolean bl = elementRef = field.getAnnotation(XmlElementRef.class) != null;
                if (attribute && element || attribute && elementRef || element && elementRef) {
                    ModelSanityCheckerTest.fail((String)("Class " + clazz.getName() + " has field " + field.getName() + " which has 2+ annotations that are not allowed together."));
                }
                if (!attribute && !element && !elementRef) continue;
                Method getter = IntrospectionSupport.getPropertyGetter(clazz, (String)field.getName());
                Method setter = IntrospectionSupport.getPropertySetter(clazz, (String)field.getName());
                ModelSanityCheckerTest.assertNotNull((String)("Getter " + field.getName() + " on class " + clazz.getName() + " is missing"), (Object)getter);
                ModelSanityCheckerTest.assertNotNull((String)("Setter " + field.getName() + " on class " + clazz.getName() + " is missing"), (Object)setter);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                LOG.debug("Class {} has method {}", (Object)clazz.getName(), (Object)((Method)accessibleObject).getName());
                if (clazz.getCanonicalName().equals(OptionalIdentifiedDefinition.class.getCanonicalName())) continue;
                attribute = ((Method)accessibleObject).getAnnotation(XmlAttribute.class) != null;
                element = ((Method)accessibleObject).getAnnotation(XmlElement.class) != null;
                elementRef = ((Method)accessibleObject).getAnnotation(XmlElementRef.class) != null;
                ModelSanityCheckerTest.assertFalse((String)("Class " + clazz.getName() + " has method " + ((Method)accessibleObject).getName() + " should not have @XmlAttribute annotation"), (boolean)attribute);
                ModelSanityCheckerTest.assertFalse((String)("Class " + clazz.getName() + " has method " + ((Method)accessibleObject).getName() + " should not have @XmlElement annotation"), (boolean)element);
                ModelSanityCheckerTest.assertFalse((String)("Class " + clazz.getName() + " has method " + ((Method)accessibleObject).getName() + " should not have @XmlElementRef annotation"), (boolean)elementRef);
            }
        }
    }
}

