/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.JmxInstrumentationUsingDefaultsTest;
import org.apache.camel.model.RouteDefinition;

public class MultiInstanceProcessorTest
extends JmxInstrumentationUsingDefaultsTest {
    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Thread.sleep(10L);
                    }
                })).to("mock:end")).to("mock:end");
            }
        };
    }

    @Override
    public void testMBeansRegistered() throws Exception {
        if (MultiInstanceProcessorTest.isPlatform("aix")) {
            return;
        }
        this.assertDefaultDomain();
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        MultiInstanceProcessorTest.assertEquals((String)("Could not find 2 endpoints: " + s), (int)2, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        MultiInstanceProcessorTest.assertEquals((String)("Could not find 1 context: " + s), (int)1, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        MultiInstanceProcessorTest.assertEquals((String)("Could not find 3 processor: " + s), (int)3, (int)s.size());
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        MultiInstanceProcessorTest.assertEquals((String)("Could not find 1 route: " + s), (int)1, (int)s.size());
    }

    @Override
    public void testCounters() throws Exception {
        if (MultiInstanceProcessorTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>", "<hello>world!</hello>"});
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        this.verifyCounter(this.mbsc, new ObjectName(this.domainName + ":type=routes,*"));
    }
}

