/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.Expression;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ExpressionNode;

public class ManagedSplitterTest
extends ManagementTestSupport {
    public void testManageSplitter() throws Exception {
        if (ManagedSplitterTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello,World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedSplitterTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedSplitterTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedSplitterTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String lan = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedSplitterTest.assertEquals((String)"${body}", (String)lan);
        String exp = (String)mbeanServer.getAttribute(on, "Expression");
        ManagedSplitterTest.assertEquals((String)"${body}", (String)exp);
        String xml = (String)mbeanServer.invoke(on, "dumpProcessorAsXml", null, null);
        ManagedSplitterTest.assertTrue((boolean)xml.contains("<split"));
        ManagedSplitterTest.assertTrue((boolean)xml.contains("</split>"));
        ManagedSplitterTest.assertTrue((boolean)xml.contains("<simple>${body}</simple>"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedSplitterTest.assertNotNull((Object)data);
        ManagedSplitterTest.assertEquals((int)3, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedSplitterTest.assertNotNull((Object)data);
        ManagedSplitterTest.assertEquals((int)15, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedSplitterTest.assertNotNull((Object)json);
        ManagedSplitterTest.assertTrue((boolean)json.contains("\"description\": \"Splits a single message into many sub-messages."));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.simple("${body}")).id("mysend")).to("mock:foo");
            }
        };
    }
}

